ORCA/M Asm65816 2.1.0

0001 191E              **********************************************************************
0002 191E              *
0003 191E              * Patch to Misc.Tools
0004 191E              * For ROM 3.0
0005 191E              *
0006 191E              * Copyright 1985-1992
0007 191E              * Apple Computer, Inc.
0008 191E              * All Rights Reserved
0009 191E              *
0010 191E              **********************************************************************
0011 191E              *
0012 191E              * 17-Sep-90         Dave Lyons
0013 191E              *
0014 191E              * Changed version number to $8302 for 6.0.
0015 191E              * Fixed ConvSeconds to return carry clear on no error, and to return
0016 191E              *   an error when convVerb is too big by one.
0017 191E              * Added SysBeep2 skeleton.
0018 191E              *
0019 191E              * 1-Oct-90          Dave Lyons
0020 191E              *
0021 191E              * Finished SysBeep2.  Added the actual call to _SendRequest.
0022 191E              *
0023 191E              * 16-Oct-90         Dave Lyons
0024 191E              *
0025 191E              * Strip off bit 15 of the SysBeep2 parameter when sending it to
0026 191E              * SendRequest.  It's just a flag specifying whether to beep if
0027 191E              * nobody accepts the request.
0028 191E              *
0029 191E              * 5-Dec-90          Dave Lyons
0030 191E              *
0031 191E              * Added VersionString call to convert 32-bit version numbers into
0032 191E              * strings (12.3.4d56).
0033 191E              *
0034 191E              * 11-Dec-90         Dave Lyons
0035 191E              *
0036 191E              * Changed definition of Stage field in VersionString version number.
0037 191E              * "Final" is now distinct from "released."
0038 191E              *
0039 191E              * 6-Jan-91          Dave Lyons
0040 191E              *
0041 191E              * Added WaitUntil call for maxxing out the speed of repeated user-
0042 191E              * visible actions (like continuous scrolling, zoom-rect effects,
0043 191E              * menu item blinking, and control blinking).
0044 191E              *
0045 191E              * 9-Jan-91          Dave Lyons
0046 191E              *
0047 191E              * Made WaitUntil multiply the delay by BRAM $60 minus 1, unless the
0048 191E              * location is $00 or $FF (defaults for ROM 1 and ROM 3).  The wait
0049 191E              * maxxes out at $F00 ticks (64 seconds).
0050 191E              *
0051 191E              * 11-Feb-91         Dave Lyons
0052 191E              *
0053 191E              * Implemented bit 14 in SysBeep2 (defers the request until the next
0054 191E              * GetNextEvent which allows mouse presses or keypresses).
0055 191E              *
0056 191E              * 14-Feb-91         Dave Lyons
0057 191E              *
0058 191E              * Made bit 14 in SysBeep2 do nothing if the Event Manager isn't started.
0059 191E              *
0060 191E              * 16-Feb-91         Dave Lyons
0061 191E              *
0062 191E              * Patched GetROMResource so I can easily override the ChooseFont
0063 191E              * resources.  (I could just put them in Sys.Resources, but this way
0064 191E              * I can continue using pointers within the resources.)
0065 191E              *
0066 191E              * 4-Mar-91          Dave Lyons
0067 191E              *
0068 191E              * Added new call StringToText to translate "Shaston 8" style text into
0069 191E              * text-display text, with or without mousetext.  Total RAM about 1.25K.
0070 191E              *
0071 191E              * 9-Mar-91          Dave Lyons
0072 191E              *
0073 191E              * A SysBeep2 call with the defer-till-GNE bit set is now ignored if
0074 191E              * there is already one pending.
0075 191E              *
0076 191E              * 29-Mar-91         Dave Lyons
0077 191E              *
0078 191E              * Added new calls ScanDevices and ShowBootInfo.
0079 191E              *
0080 191E              * 1-Apr-91          Dave Lyons
0081 191E              *
0082 191E              * Added 2 scanlines to the top of the area that FillScreenBottom
0083 191E              * fills with $DDDD when we are about to run off the right edge.
0084 191E              *
0085 191E              * 2-Apr-91          Dave Lyons
0086 191E              *
0087 191E              * Change ShowBootInfo to draw to the Text screen or SHR screen,
0088 191E              * but not both.  Fix first-time-here logic accordingly.
0089 191E              *
0090 191E              * 14-Apr-91         Dave Lyons
0091 191E              *
0092 191E              * Change StringToText so that if the source text is contained in
0093 191E              * the result buffer, I make a separate copy of the source text
0094 191E              * before processing.  This is partly for the benefit of ProDOS
0095 191E              * JudgeName.
0096 191E              *
0097 191E              * Added a ResultFlags parameter to StringToText so the caller
0098 191E              * can tell if any changes were made to the string.
0099 191E              *
0100 191E              * 6-May-91          Dave Lyons
0101 191E              *
0102 191E              * Added parnoia check to ShowBootInfo so an icon can't get drawn
0103 191E              * past the bottom of the screen.
0104 191E              *
0105 191E              * 9-May-91          Dave Lyons
0106 191E              *
0107 191E              * Fixed lots of error handling in ConvSeconds.  Implemented the
0108 191E              * cool ProDOS 8 year scheme.
0109 191E              *
0110 191E              * 20-May-91         Dave Lyons
0111 191E              *
0112 191E              * Setting bit 31 of the iconPtr to ShowBootInfo makes it re-use
0113 191E              * the previous position (the icon that overprints it ought to be
0114 191E              * the same width!).
0115 191E              *
0116 191E              * Patched SysFailMgr to enable text page 1 shadowing.
0117 191E              *
0118 191E              * Changed ConvSeconds FromProDOS (verb 5) so it doesn't trash the
0119 191E              * input buffer.  Verb 11 (HC to Seconds) restores the input buffer.
0120 191E              *
0121 191E              * 2-Jul-91          Dave Lyons
0122 191E              *
0123 191E              * In ShowBootInfo, added check for bit 1 of BRAM location $5F.  If
0124 191E              * set, we don't draw the icon.
0125 191E              *
0126 191E              * SysBeep2 now sends to Apple~SoundCP~ before broadcasting the request.
0127 191E              *
0128 191E              * 8-Jul-91          Dave Lyons
0129 191E              *
0130 191E              * ShowBootInfo now does nothing if QuickDraw is started (in case some
0131 191E              * DA or CDev gets initialized at some time other than boot time).
0132 191E              * Also, bit 31 of the string pointer makes ShowBootInfo reinitialize
0133 191E              * itself.  (This happens at DeskStartUp time.)
0134 191E              *
0135 191E              * 22-Aug-91         Dave Lyons
0136 191E              *
0137 191E              * ShowBootInfo now prints a CR after printing a text string.
0138 191E              *
0139 191E              * 17-Sep-91         Dave Lyons
0140 191E              *
0141 191E              * Link some stuff into Tool.Setup instead of TS2/3.  Routines moved
0142 191E              * are:  UnPackBytes, ConvSeconds, SysBeep2, VersionString, WaitUntil,
0143 191E              * StringToText, ShowBootInfo, ScanDevices.
0144 191E              *
0145 191E              * 14-Oct-91         Dave Lyons
0146 191E              *
0147 191E              * Made StringToText return a reasonable length when possible even if
0148 191E              * it returns error $034F, buffer too small.
0149 191E              *
0150 191E              * 1-Nov-91          Dave Lyons
0151 191E              *
0152 191E              * Made MTBootInit zap E1/0196 and E1/0197, so that ReadMouse will
0153 191E              * return a valid Status byte.
0154 191E              *
0155 191E              * 16-Jan-92         Dave Lyons
0156 191E              *
0157 191E              * StringToText:  Changed translation of German "§" ($A7) to "ss".
0158 191E              * Made some optimizations, including making the translate table
0159 191E              * entries 5 bytes each instead of 6.  Added 32 new translations
0160 191E              * per Yvan Koenig.
0161 191E              *
0162 191E              * 21-Jan-92         Dave Lyons
0163 191E              *
0164 191E              * StringToText:  Fixed flags on the §-->ss translation to show
0165 191E              * that it's a lengthening translation.
0166 191E              *
0167 191E              * 27-Jan-92         Dave Lyons
0168 191E              *
0169 191E              * Added ToBramSetupPatch (sets bank to $00 around call).
0170 191E              *
0171 191E              * 30-Jan-92         Dave Lyons
0172 191E              *
0173 191E              * Fixed a problem in UnPackBytes where a %10xxxxxx packet was not
0174 191E              * correctly checking the remaining space in the output buffer (it
0175 191E              * was off by a factor of two).
0176 191E              *
0177 191E              * 5-Feb-92          Dave Lyons
0178 191E              *
0179 191E              * Version $0302 for 6.0 final.
0180 191E              *
0181 191E              * 6-Feb-92          Dave Lyons
0182 191E              *
0183 191E              * Oops, fixed bad compare in StringToText (introduced 16-Jan).
0184 191E              *
0185 191E              **********************************************************************
0186 191E              *
0187 191E              * Begin 6.0.1
0188 191E              *
0189 191E              * 12-Mar-92         Dave Lyons
0190 191E              *
0191 191E              * Version $8303.
0192 191E              *
0193 191E              * Make ShowBootInfo start a new row (higher) if the first one fills up.
0194 191E              *
0195 191E              * 23-Jun-92         Dave Lyons
0196 191E              *
0197 191E              * SysFailMgr now has better default messages for errors $0027 and $0201.
0198 191E              *
0199 191E              * 1-Jul-92          Dave Lyons
0200 191E              *
0201 191E              * Added message for SysFailMgr errors $0308, $0681, $0682.
0202 191E              *
0203 191E              * 18-Jul-92         Dave Lyons
0204 191E              *
0205 191E              * Made SysBeep2 send systemSaysForceUndim ($000D), for all codes except
0206 191E              * $006x (screen blanking, screen unblanking).
0207 191E              *
0208 191E              * 20-Aug-92         Dave Lyons
0209 191E              *
0210 191E              * New calls AlertMessage and DoSysPrefs.
0211 191E              *
0212 191E              * 1-Oct-92          Dave Lyons for 6.0.1d11
0213 191E              *
0214 191E              * DoSysPrefs result is the *old* prefs value, not the new one.
0215 191E              *
0216 191E              * 22-Oct-92         Dave Lyons for 6.0.1d12
0217 191E              *
0218 191E              * DoSysPrefs returns error $0301 (and a random result) if GS/OS
0219 191E              * is not the active operating system.
0220 191E              *
0221 191E              * 2-Apr-93 DAL
0222 191E              *
0223 191E              * Version $0303 for 6.0.1.
0224 191E              *
0225 191E              **********************************************************************
0226 191E
0227 191E                       entry ConvSeconds 
0228 191E                       entry SysBeep2                 ;17-Sep-90 DAL
0229 191E                       entry UnPackBytes              ;23-Oct-90 DAL
0230 191E                       entry VersionString            ;5-Dec-90 DAL
0231 191E                       entry WaitUntil                ;6-Jan-91 DAL
0232 191E                       entry GetROMResource           ; 16-Feb-91 DAL
0233 191E                       entry StringToText             ;4-Mar-91 DAL
0234 191E                       entry ScanDevices              ;29-Mar-91 DAL
0235 191E                       entry ShowBootInfo             ;29-Mar-91 DAL
0236 191E                       entry NewSysFail               ;20-May-91 DAL
0237 191E
0238 191E              MTVersionNumber equ   $0303             ;2-Apr-93 DAL
0239 191E
0240 191E                       include ':::sys.equs.asm' 
0241 191E                       include 'all.macros' 
0242 191E
0243 191E              PendingSysBeep2 equ   $E1167E
0244 191E
0245 191E              ****************************************************************
0246 191E              *
0247 191E              * ToBramSetupPatch -- new for 6.0d66, DAL
0248 191E              *
0249 191E              * We never documented that you should set the bank to $00 when
0250 191E              * calling ToBramSetup ($E10094), so people call it with random
0251 191E              * banks, and the firmware trashes memory while trying to fiddle
0252 191E              * with softswitches ($C036 and $C02D).
0253 191E              *
0254 191E              * (This patch gets installed by CommonPatches in Tool.Setup.)
0255 191E              *
0256 191E              ****************************************************************
0257 191E              ToBramSetupPatch proc export 
0258 191E                       export oldToBramSetupCall 
0259 191E
0260 191E 8B                    phb   
0261 191F F4 00 00              pea   0
0262 1922 AB                    plb   
0263 1923 AB                    plb   
0264 1924 22 77 77 77  oldToBramSetupCall jsl   >$777777
0265 1928 AB                    plb   
0266 1929 6B                    rtl   
0267 192A
0268 192A                       EndP 
0269 192A
0270 192A
0271 192A                       eject 
0272 192A                       title 'Unpack bytes' 
0273 192A              *
0274 192A              * Patched 23-Oct-90 DAL for System 6.0
0275 192A              *
0276 192A              * There's a small but deeply-buried bug in the ROM version (01 and 03).
0277 192A              *
0278 192A              ************************************************************************
0279 192A              *                                                                      *
0280 192A              *  FUNCTION UnPackBytes(    BufPtr : POINTER;                          *
0281 192A              *                           BufSize: INTEGER;                          *
0282 192A              *                       VAR PicPtr : POINTER;                          *
0283 192A              *                       VAR PicSize: INTEGER) : INTEGER;               *
0284 192A              *                                                                      *
0285 192A              *  Params:  BufPtr - pointer to area containing packed data            *
0286 192A              *           BufSize- max size of area containing packed data           *
0287 192A              *           PicPtr - Pointer to start of area to unpack into           *
0288 192A              *           PicSize- Maximum space available for unpacked picture      *
0289 192A              *                                                                      *
0290 192A              *  Returns: UnPackBytes return Value: Actual number of bytes unpacked  *
0291 192A              *           PicPtr: Updated to one past end of last byte unpacked      *
0292 192A              *           PicSize: reduced by number of bytes of picture generated   *
0293 192A              *                                                                      *
0294 192A              *        ------------------------------------------------------        *
0295 192A              *                                                                      *
0296 192A              *  Sample Calls:                                                       *
0297 192A              *                                                                      *
0298 192A              *        OpenFile;                                                     *
0299 192A              *        Mark:=StartofFile;                                            *
0300 192A              *        PicSize:=$7d00;                                               *
0301 192A              *        BufSize:=$400;                                                *
0302 192A              *        REPEAT                                                        *
0303 192A              *          SetFileMark(Mark);                                          *
0304 192A              *          Read(f,BufPtr,Bufsize);                                     *
0305 192A              *          HowMuch:=UnPackBytes(BufPtr,BufSize,PicPtr,PicSize);        *
0306 192A              *          Mark:=Mark+HowMuch;                                         *
0307 192A              *        UNTIL ( (PicSize=0) OR EOF(f) );                              *
0308 192A              *                                                                      *
0309 192A              *     -----------------------------------------------------------      *
0310 192A              *                                                                      *
0311 192A              *    Packed data encryption format:                                    *
0312 192A              *                                                                      *
0313 192A              *        %00xxxxxx : (xxxxxx : 0->63) = 1 to 64 bytes follow -         *
0314 192A              *                                              All Different           *
0315 192A              *                                                                      *
0316 192A              *        %01xxxxxx : (xxxxxx : 1,2,3,5,6,7) = 1,2,3,5,6,7 repeats -    *
0317 192A              *                                              of next byte            *
0318 192A              *                                                                      *
0319 192A              *        %10xxxxxx : (xxxxxx : 0->63) = 1 to 64 repeats -              *
0320 192A              *                                              of next 4 bytes         *
0321 192A              *                                                                      *
0322 192A              *        %11xxxxxx : (xxxxxx : 0->63) = 1 to 64 times 4 repeats -      *
0323 192A              *                                              of next byte            *
0324 192A              *                                                                      *
0325 192A              *    -----------------------------------------------------------       *
0326 192A              *                                                                      *
0327 192A              *  Written By: Eagle I. Berns                                          *
0328 192A              *                                                                      *
0329 192A              *  Modification History:                                               *
0330 192A              *                                                                      *
0331 192A              *  10-DEC-85   EIB                      First coding begun             *
0332 192A              *   5-Mar-87   SEG                      Error code returned is now 0   *
0333 192A              *                                       in both Pack and Unpack        *
0334 192A              *  23-Oct-90   DAL                      Fixed low-probability compare  *
0335 192A              *                                       bug (see comments)             *
0336 192A              *                                                                      *
0337 192A              ************************************************************************
0338 192A
0339 192A              UnPackBytes PROC export 
0340 192A
0341 192A              from     equ   1
0342 192A              to       equ   from+4
0343 192A              endbuf   equ   to+4
0344 192A              temp     equ   endbuf+4
0345 192A              count    equ   temp+4
0346 192A              lf       equ   count+2
0347 192A
0348 192A              Origdrct equ   lf+2
0349 192A
0350 192A              rtl1     equ   origdrct+2
0351 192A              rtl2     equ   rtl1+3
0352 192A
0353 192A              PicSizeP equ   rtl2+3
0354 192A              PicPtrP  equ   PicSizeP+4
0355 192A              Bufsize  equ   PicPtrP+4
0356 192A              BufPtr   equ   BufSize+2
0357 192A              Result   equ   BufPtr+4
0358 192A              ;	  -> +2
0359 192A
0360 192A 0B                    PHD                            ; SET UP STACK AS ZERO PAGE +PARMS
0361 192B 3B                    TSC   
0362 192C 38                    SEC   
0363 192D E9 14 00              SBC   #ORIGDRCT-1
0364 1930 1B                    TCS   
0365 1931 5B                    TCD   
0366 1932
0367 1932 A7 21                 LDA   [PICPTRP]                ; GET THE ARGS.
0368 1934 AA                    TAX                            ; (PicPtrP needs dereference)
0369 1935 A0 02 00              LDY   #2
0370 1938 B7 21                 LDA   [PICPTRP],Y
0371 193A 85 07                 STA   TO+2
0372 193C 86 05                 STX   TO
0373 193E
0374 193E A7 1D                 LDA   [PICSIZEP]
0375 1940 85 11                 STA   COUNT
0376 1942
0377 1942 A5 27                 LDA   BUFPTR
0378 1944 85 01                 STA   FROM
0379 1946 18                    CLC   
0380 1947 65 25                 ADC   BUFSIZE
0381 1949 85 09                 STA   ENDBUF
0382 194B A5 29                 LDA   BUFPTR+2
0383 194D 85 03                 STA   FROM+2
0384 194F 69 00 00              ADC   #0
0385 1952 85 0B                 STA   ENDBUF+2
0386 1954
0387 1954 A0 00 00     DoUnpack LDY   #0
0388 1957
0389 1957 B7 01                 LDA   [FROM],Y                 ; GET THE COMMAND
0390 1959 85 0D                 STA   TEMP
0391 195B 29 3F 00              AND   #$3F
0392 195E AA                    TAX                            ; GET COUNT ONLY INTO X
0393 195F E6 01                 INC   FROM                     ; BUMP TO FIRST BYTE TO TRANSFER
0394 1961 D0 02                 BNE   M1
0395 1963 E6 03                 INC   FROM+2
0396 1965 24 0C        M1       BIT   TEMP-1                   ; V & C BITS GIVE COMMAND
0397 1967 30 04                 BMI   REP4
0398 1969 70 0D                 BVS   REP1                     ; 01xxxxxx -> REPEAT NEXT 1 BYTE
0399 196B 80 08                 BRA   DIFF                     ; 00xxxxxx -> ALL DIFFERENT
0400 196D 70 16        REP4     BVS   REP41                    ; 11xxxxxx -> REPEAT 4 OF NEXT 1 BYTE
0401 196F 80 1C                 BRA   REP44                    ; 10xxxxxx -> REPEAT OF NEXT 4 BYTES
0402 1971
0403 1971 68           OUTP     PLA   
0404 1972 4C 5B 1F              JMP   UDONE                    ; GO FINISH UP
0405 1975
0406 1975              *****************************************
0407 1975              *                                       *
0408 1975              * DIFF : 0 ->63 IN A MEANS  1->64       *
0409 1975              *   DIFFERENT BYTES FOLLOW TO BE MOVED  *
0410 1975              *                                       *
0411 1975              *****************************************
0412 1975 48           DIFF     PHA                            ; WHEN WE GO TO COMMON CODE, WE NEED
0413 1976                                                      ;  SOMETHING STACKED (OTHER CALLS USE IT)
0414 1976 80 1C                 BRA   JOIN
0415 1978
0416 1978              *****************************************
0417 1978              *                                       *
0418 1978              * REP1 : 1,2,3,5,6,7 REPEATS OF FOLLOW- *
0419 1978              *        ING BYTE.                      *
0420 1978              *                                       *
0421 1978              *****************************************
0422 1978
0423 1978
0424 1978 A5 0D        REP1     LDA   TEMP                     ; PUT BYTE IF LOW & HIGH & ON STACK
0425 197A 29 00 FF              AND   #$FF00
0426 197D 48                    PHA   
0427 197E EB                    XBA   
0428 197F 03 01                 ORA   1,S
0429 1981 83 01                 STA   1,S
0430 1983 80 0F                 BRA   JOIN                     ; JOIN UP, X=LEN IS CORRECT STILL
0431 1985
0432 1985              *****************************************
0433 1985              *                                       *
0434 1985              * REP41 : IS SAME AS REP1 ABOVE, EXCEPT *
0435 1985              *         COUNT IN X MUST BE 4 TIMES >  *
0436 1985              *                                       *
0437 1985              *****************************************
0438 1985 E8           REP41    INX   
0439 1986 8A                    TXA   
0440 1987 0A                    ASL   A
0441 1988 0A                    ASL   A
0442 1989 AA                    TAX   
0443 198A CA                    DEX   
0444 198B 80 EB                 BRA   REP1
0445 198D
0446 198D              *****************************************
0447 198D              *                                       *
0448 198D              * REP44 : MUST SET UP FOR 2 STORES I.E. *
0449 198D              *         4 BYTES WORTH, AND COUNT IS   *
0450 198D              *         DOUBLED (2 STORES EACH TIME)  *
0451 198D              *                                       *
0452 198D              *****************************************
0453 198D E8           REP44    INX   
0454 198E 8A                    TXA   
0455 198F 0A                    ASL   A
0456 1990              *** added 30-Jan-92 DAL
0457 1990 0A                    asl   a                        ;actually, quadruple X
0458 1991              *** end 30-Jan-92
0459 1991 AA                    TAX                            ; FIRST DOUBLE X
0460 1992 CA                    DEX   
0461 1993 48                    PHA                            ; MUST PUT SOMETHING ON STACK FOR
0462 1994                                                      ;  OTHER CASES
0463 1994
0464 1994              *        BRA   JOIN		; WE FIND 4 BYTES AT [FROM],
0465 1994              * (FALL THROUGH TO JOIN)	; SO MUST REMEMBER TO FIND IT THERE
0466 1994
0467 1994              *****************************************
0468 1994              *                                       *
0469 1994              * JOIN : HERE, THE LOAD STORE SEQUENCE  *
0470 1994              *        OF DATA TRANSFER TAKES PLACE   *
0471 1994              *                                       *
0472 1994              *****************************************
0473 1994 E4 11        JOIN     CPX   COUNT                    ; BE SURE THERE'S ROOM
0474 1996 B0 D9                 BGE   OUTP                     ; NO - DONE   (BUT PULL OFF EXTRA PUSH)
0475 1998
0476 1998 A9 01 00              LDA   #1                       ; CHECK IF LENGTH WOULD GO OVER
0477 199B 24 0C                 BIT   TEMP-1                   ; DEPENDS ON TYPE OF CMD.
0478 199D 70 09                 BVS   L1                       ; LEN=1 FOR %01 & %11
0479 199F 30 04                 BMI   L4                       ; LEN=4 FOR %10
0480 19A1 8A                    TXA   
0481 19A2 1A                    INC   A                        ; LEN=N+1 FOR %00..N...
0482 19A3 80 03                 BRA   L1
0483 19A5 A9 04 00     L4       LDA   #4
0484 19A8 18           L1       CLC                            ; FROM+LEN .LT. ENDBUF MEANS NOT DONE
0485 19A9 65 01                 ADC   FROM
0486 19AB 48                    PHA                            ; SAVE FOR COMPARE
0487 19AC A5 03                 LDA   FROM+2
0488 19AE 69 00 00              ADC   #0
0489 19B1 C5 0B                 CMP   ENDBUF+2
0490 19B3 90 0E                 BCC   NOTDONP
0491 19B5 D0 09                 bne   WeAreDone                ;added 23-Oct-90 DAL
0492 19B7 68                    PLA   
0493 19B8 C5 09                 CMP   ENDBUF
0494 19BA 90 08                 BLT   NOTDON
0495 19BC F0 06                 BEQ   NOTDON
0496 19BE 80 B1                 BRA   OUTP
0497 19C0
0498 19C0 68           WeAreDone pla                           ;added 23-Oct-90 DAL
0499 19C1 80 AE                 bra   OutP                     ;added 23-Oct-90 DAL
0500 19C3
0501 19C3 68           NOTDONP  PLA   
0502 19C4
0503 19C4 E0 00 00     NOTDON   CPX   #0                       ; (NEEDED FOR 1ST ENTRY IN LOOP)
0504 19C7 30 53        LOOP     BMI   DOUPD                    ; YES
0505 19C9
0506 19C9
0507 19C9              *****************************************
0508 19C9              *                                       *
0509 19C9              * MOVEIT : USED LOCALLY TO FETCH PROPER *
0510 19C9              *          INPUT, DEPENDING ON TYPE OF  *
0511 19C9              *          CMD. BEING PROCESSED         *
0512 19C9              *  NOTE: X<0 MEANS STORE 1 BYTE ONLY    *
0513 19C9              *****************************************
0514 19C9 24 0C                 BIT   TEMP-1                   ; THIS HAS THE FLAGS
0515 19CB 30 36                 BMI   MREP4
0516 19CD 70 1A                 BVS   MREP1
0517 19CF E0 00 00              CPX   #0                       ; IF NEG. IT'S ONE BYTE ONLY
0518 19D2 F0 09                 BEQ   MSPEC
0519 19D4 B7 01                 LDA   [FROM],Y
0520 19D6 97 05                 STA   [TO],Y
0521 19D8 C8                    INY   
0522 19D9 C8                    INY   
0523 19DA 4C 18 1F              JMP   NDMOV
0524 19DD
0525 19DD E2 20        MSPEC    SEP   #%00100000
0526 19DF B7 01                 LDA   [FROM],Y
0527 19E1 97 05                 STA   [TO],Y
0528 19E3 C2 20                 REP   #%00100000
0529 19E5 C8                    INY   
0530 19E6 4C 18 1F              JMP   NDMOV
0531 19E9
0532 19E9 E0 00 00     MREP1    CPX   #0
0533 19EC F0 09                 BEQ   M2SPEC
0534 19EE A3 01                 LDA   1,S
0535 19F0 97 05                 STA   [TO],Y
0536 19F2 C8                    INY   
0537 19F3 C8                    INY   
0538 19F4 4C 18 1F              JMP   NDMOV
0539 19F7
0540 19F7 E2 20        M2SPEC   SEP   #%00100000
0541 19F9 A3 01                 LDA   1,S
0542 19FB 97 05                 STA   [TO],Y
0543 19FD C2 20                 REP   #%00100000
0544 19FF C8                    INY   
0545 1A00 4C 18 1F              JMP   NDMOV
0546 1A03
0547 1A03 70 E4        MREP4    BVS   MREP1                    ;REP41 SAME AS REP1 BUT LARGER COUNT
0548 1A05 A7 01                 LDA   [FROM]
0549 1A07 97 05                 STA   [TO],Y
0550 1A09 5A                    PHY                            ; HOLD Y A SEC
0551 1A0A A0 02 00              LDY   #2
0552 1A0D B7 01                 LDA   [FROM],Y
0553 1A0F 7A                    PLY   
0554 1A10 C8                    INY   
0555 1A11 C8                    INY   
0556 1A12 97 05                 STA   [TO],Y
0557 1A14 C8                    INY   
0558 1A15 C8                    INY   
0559 1A16              *** added 30-Jan-92 DAL -- corresponds to extra ASL A added above
0560 1A16 CA                    dex   
0561 1A17 CA                    dex   
0562 1A18              *** end 30-Jan-92
0563 1A18
0564 1A18              ******
0565 1A18 CA           NDMOV    DEX   
0566 1A19 CA                    DEX   
0567 1A1A 80 AB                 BRA   LOOP                     ; GO DO NEXT ONES
0568 1A1C
0569 1A1C 68           DOUPD    PLA                            ; GET RID OF EXTRA PUSH
0570 1A1D A5 0D                 LDA   TEMP                     ; UPDATE APPROPRIATE POINTERS
0571 1A1F 29 3F 00              AND   #$3F
0572 1A22 1A                    INC   A
0573 1A23 24 0C                 BIT   TEMP-1
0574 1A25 30 13                 BMI   XREP4                    ; FROM DEPENDS ON TYPE
0575 1A27 50 03                 BVC   XDIFF                    ; FOR 00xxxxxx ADD LENGTH
0576 1A29 A9 01 00     FP1      LDA   #1                       ; FOR 01xxxxxx ADD 1
0577 1A2C 18           XDIFF    CLC   
0578 1A2D 65 01                 ADC   FROM
0579 1A2F 85 01                 STA   FROM
0580 1A31 A5 03                 LDA   FROM+2
0581 1A33 69 00 00              ADC   #0
0582 1A36 85 03                 STA   FROM+2
0583 1A38 80 07                 BRA   DOTO
0584 1A3A
0585 1A3A 70 ED        XREP4    BVS   FP1                      ; FOR 11xxxxxx ALSO ADD 1
0586 1A3C A9 04 00              LDA   #4                       ; FOR 10xxxxxx ADD 4
0587 1A3F 80 EB                 BRA   XDIFF
0588 1A41
0589 1A41 98           DOTO     TYA                            ; Y IS OUTPUT COUNT
0590 1A42 18                    CLC   
0591 1A43 65 05                 ADC   TO
0592 1A45 85 05                 STA   TO
0593 1A47 A5 07                 LDA   TO+2
0594 1A49 69 00 00              ADC   #0
0595 1A4C 85 07                 STA   TO+2
0596 1A4E 98                    TYA   
0597 1A4F 85 0D                 STA   TEMP
0598 1A51 A5 11                 LDA   COUNT
0599 1A53 38                    SEC   
0600 1A54 E5 0D                 SBC   TEMP
0601 1A56 85 11                 STA   COUNT
0602 1A58 4C 54 1E              JMP   DOUNPACK
0603 1A5B
0604 1A5B A5 01        UDONE    LDA   FROM
0605 1A5D 38                    SEC   
0606 1A5E E5 27                 SBC   BUFPTR
0607 1A60 3A                    DEC   A
0608 1A61 85 2B                 STA   RESULT                   ; SET RESULT LENGTH
0609 1A63
0610 1A63 A5 05                 LDA   TO
0611 1A65 38                    SEC   
0612 1A66 E7 21                 SBC   [PICPTRP]
0613 1A68 48                    PHA                            ; HOLD IT, NEED SIZE - IT
0614 1A69 A7 1D                 LDA   [PICSIZEP]
0615 1A6B 38                    SEC   
0616 1A6C E3 01                 SBC   1,S
0617 1A6E 87 1D                 STA   [PICSIZEP]
0618 1A70 68                    PLA   
0619 1A71
0620 1A71 A5 05                 LDA   TO
0621 1A73 87 21                 STA   [PICPTRP]
0622 1A75 A5 07                 LDA   TO+2
0623 1A77 A0 02 00              LDY   #2
0624 1A7A 97 21                 STA   [PICPTRP],Y
0625 1A7C
0626 1A7C A5 15                 LDA   ORIGDRCT
0627 1A7E 5B                    TCD   
0628 1A7F A3 17                 LDA   RTL1,S                   ;FIX STACK UP CORRECTLY
0629 1A81 83 25                 STA   RESULT-6,S
0630 1A83 A3 19                 LDA   RTL1+2,S
0631 1A85 83 27                 STA   RESULT-4,S
0632 1A87 A3 1B                 LDA   RTL1+4,S
0633 1A89 83 29                 STA   RESULT-2,S
0634 1A8B 3B                    TSC   
0635 1A8C 18                    CLC   
0636 1A8D 69 24 00              ADC   #RESULT-7
0637 1A90 1B                    TCS   
0638 1A91 A9 00 00              LDA   #0                       ; fix by SEG 5 March 87
0639 1A94 18                    CLC                            ; fix by SEG 5 March 87
0640 1A95 6B                    RTL   
0641 1A96
0642 1A96                       ENDP 
0643 1A96
0644 1A96
0645 1A96                       EJECT 
0646 1A96              *******************************************************************************
0647 1A96              *
0648 1A96              * ConvSeconds   $3703
0649 1A96              *
0650 1A96              * Description:      This routine converts number of seconds from 1904 to date or 
0651 1A96              *                   the passed date into seconds since 1904. It does so by cleverly
0652 1A96              *                   patching the toWriteTime and toReadTime vectors...
0653 1A96              *
0654 1A96              * Inputs:           Direction - Integer tells whether to convert to or from
0655 1A96              *                   Seconds - Longint   the number of seconds since 1904 (to from)
0656 1A96              *                   Date - ptr          pointer to area to store the date...
0657 1A96              *
0658 1A96              * Outputs:          seconds - longint   the number of seconds returned (from into)
0659 1A96              *
0660 1A96              * Direction indicators are:
0661 1A96              *                   0 - From Seconds to MiscTools hex time format
0662 1A96              *                   1 - From MiscTools hex time to seconds
0663 1A96              *                   2 - From Seconds to ASCII Time 
0664 1A96              *                   3 - NOT IMPLEMENTED
0665 1A96              *                   4 - From Seconds to ProDOS DateTime Record
0666 1A96              *                   5 - From ProDOS DateTime to Seconds
0667 1A96              *                   6 - Get Current seconds
0668 1A96              *                   7 - Set Current seconds
0669 1A96              *                   8 - ToMTFromProDOS
0670 1A96              *                   9 - ToProDOSFromMT
0671 1A96              *                   10 - From seconds to IdunaHexTime
0672 1A96              *                   11 - From IdunaHexTime to seconds
0673 1A96              *
0674 1A96              * Seconds Input -   LongInteger representing the number of seconds since Jan 1 1904. This is
0675 1A96              *                   used in all From Seconds conversions and in Set Current Seconds.
0676 1A96              *
0677 1A96              * Date Input -      Pointer to a properly formated date for the direction indicated ASCII time
0678 1A96              *                   should have a 80 byte buffer.  Not used for GetSeconds.
0679 1A96              *
0680 1A96              * Seconds Output -  Contains the number of seconds since jan 1 1904 for all conversions. for
0681 1A96              *                   from seconds calls, this contains the seconds input. For to seconds calls
0682 1A96              *                   this contains the result of the call.
0683 1A96              *
0684 1A96              * Formats Used:
0685 1A96              *
0686 1A96              * ProDOS DateTime   Word                Date
0687 1A96              *                     Bits 0-4          Day (1-31)
0688 1A96              *                     Bits 5-8          Month (1-12)
0689 1A96              *                     Bits 9-15         Year (year-1900)
0690 1A96              *                   Word                Time
0691 1A96              *                     Bits 0-7          Minute (0-59)
0692 1A96              *                     Bits 8-15         Hour (0-23)
0693 1A96              *
0694 1A96              * MTHex Format      Byte                Seconds (0-59)
0695 1A96              *                   Byte                Minute (0-59)
0696 1A96              *                   Byte                hour (0-23)
0697 1A96              *                   Byte                Year (year-1900)
0698 1A96              *                   Byte                day (0-30)
0699 1A96              *                   Byte                month (0-11)
0700 1A96              *                   byte                null (MUST be zero)
0701 1A96              *                   byte                weekday (1-7 1=sunday)
0702 1A96              *
0703 1A96              * IdunaHexTime      Byte                Seconds (0-59)
0704 1A96              *                   Byte                Minute (0-59)
0705 1A96              *                   Byte                hour (0-23)
0706 1A96              *                   Byte                Year (year-1900)
0707 1A96              *                   Byte                day (1-31)
0708 1A96              *                   Byte                month (1-12)
0709 1A96              *                   byte                null (MUST be zero)
0710 1A96              *                   byte                weekday (1-7 1=sunday)
0711 1A96              *
0712 1A96              *******************************************************************************
0713 1A96              ConvSeconds PROC Export 
0714 1A96
0715 1A96              ; Equates for the stack frame...
0716 1A96              oldDPage equ   1
0717 1A96              oldPStatus equ   oldDPage+2
0718 1A96              theRTL1  equ   oldPStatus+1
0719 1A96              TheRTL2  equ   theRTL1+3
0720 1A96              theDate  equ   theRTL2+3
0721 1A96              theSecs  equ   theDate+4
0722 1A96              theVerb  equ   theSecs+4
0723 1A96              result   equ   theVerb+2
0724 1A96
0725 1A96              BadTimeVerb equ   $0390                 ; error for a bad time verb
0726 1A96              BadTimeData equ   $0391                 ; input data was bad (Bad boy!)
0727 1A96
0728 1A96 08                    php   
0729 1A97 0B                    phd                            ; set up our stack frame...
0730 1A98 3B                    tsc   
0731 1A99 5B                    tcd   
0732 1A9A
0733 1A9A A5 12                 lda   <theVerb                 ; call the proper routine...
0734 1A9C 0A                    asl   a
0735 1A9D C9 18 00              cmp   #TimeTblSize             ; are we out of bounds? (removed "+1" 17-Sep-90 DAL)
0736 1AA0 B0 0B                 bge   @BadTime                 ; if so we have a bad verb
0737 1AA2 AA                    tax   
0738 1AA3 FC C8 1F              jsr   (timetbl,x)              ; call the proper routine...
0739 1AA6 B0 08                 bcs   @Endit                   ;added 9-May-91 DAL -- each routine must return CLC or SEC/X=error
0740 1AA8 A2 00 00              ldx   #0                       ; set the noerrorflag
0741 1AAB 80 03                 bra   @EndIt
0742 1AAD
0743 1AAD A2 90 03     @BadTime ldx   #BadTimeVerb
0744 1AB0 A5 04        @Endit   lda   <theRTL1
0745 1AB2 85 0E                 sta   <theSecs
0746 1AB4 A5 06                 lda   <theRTL1+2
0747 1AB6 85 10                 sta   <theSecs+2
0748 1AB8 A5 08                 lda   <theRTL1+4
0749 1ABA 85 12                 sta   <theSecs+4
0750 1ABC
0751 1ABC 2B                    pld   
0752 1ABD 28                    plp   
0753 1ABE
0754 1ABE 68                    pla                            ; pull off parameters
0755 1ABF 68                    pla   
0756 1AC0 68                    pla   
0757 1AC1 68                    pla   
0758 1AC2 68                    pla   
0759 1AC3
0760 1AC3 8A                    txa                            ; recover the error code..
0761 1AC4 C9 01 00              cmp   #1                       ; was CMP #0 (17-Sep-90 DAL)
0762 1AC7 6B                    rtl                            ; return to caller...
0763 1AC8
0764 1AC8 F0 20        TimeTbl  DC W:ToMTHexFormat             ;0
0765 1ACA 12 21                 DC W:fromMTHexFormat           ;1
0766 1ACC 01 21                 DC W:ToASCIITimeFormat         ;2
0767 1ACE 23 21                 DC W:TimeDummy                 ;3
0768 1AD0 43 20                 DC W:ToProDOS                  ;4  convert to ProDOS Date Time...
0769 1AD2 95 20                 DC W:FromProDOS                ;5
0770 1AD4 0B 20                 DC W:JustGetCurrent            ;6
0771 1AD6 27 20                 DC W:JustSetCurrent            ;7
0772 1AD8 B1 20                 DC W:ToMTFromProDOS            ;8
0773 1ADA 46 20                 DC W:ToProDOSFromMT            ;9
0774 1ADC E0 1F                 DC W:ToIdHexFormat             ;10
0775 1ADE F1 1F                 DC W:fromIDHexFormat           ;11
0776 1AE0              TimeTblSize equ   *-TimeTbl
0777 1AE0
0778 1AE0              ;-----------------------------------------------------------------------
0779 1AE0              ;
0780 1AE0              ToIDHexFormat  
0781 1AE0              ; Special routine that bumps the output from the ToMTHexTime format
0782 1AE0              ; routine, this is put in for the convenience of the Iduna guys...
0783 1AE0              ;
0784 1AE0 20 F0 20              jsr   ToMTHexFormat            ; convert to the hex format...
0785 1AE3 B0 0B                 bcs   @ErrorBad                ; some form of error occured!
0786 1AE5 A0 04 00              ldy   #4
0787 1AE8 B7 0A                 lda   [theDate],y              ; get the day/month word in...
0788 1AEA 18                    clc   
0789 1AEB 69 01 01              adc   #$0101                   ; don't have to worry about an overflow!
0790 1AEE 97 0A                 sta   [theDate],y
0791 1AF0              ; note: carry is clear
0792 1AF0              @ErrorBad  
0793 1AF0 60                    rts   
0794 1AF1
0795 1AF1              ;-----------------------------------------------------------------------
0796 1AF1              ;
0797 1AF1              FromIDHexFormat  
0798 1AF1              ; Special routine that bumps the output from the ToMTHexTime format
0799 1AF1              ; routine, this is put in for the convenience of the Iduna guys...
0800 1AF1              ;
0801 1AF1 A0 04 00              ldy   #4                       ; perform the necessary subtraction..
0802 1AF4 B7 0A                 lda   [theDate],y
0803 1AF6 38                    sec   
0804 1AF7 E9 01 01              sbc   #$0101
0805 1AFA 97 0A                 sta   [theDate],y
0806 1AFC 20 12 21              jsr   fromMTHexFormat          ; convert to the hex format...
0807 1AFF              *** added 20-May-91 DAL -- put the user's buffer back how it was
0808 1AFF A0 04 00              ldy   #4
0809 1B02 B7 0A                 lda   [theDate],y
0810 1B04 18                    clc   
0811 1B05 69 01 01              adc   #$0101
0812 1B08 97 0A                 sta   [theDate],y
0813 1B0A              *** end of 20-May-91 DAL
0814 1B0A 60                    rts   
0815 1B0B
0816 1B0B              ;-----------------------------------------------------------------------
0817 1B0B              ;
0818 1B0B              JustGetCurrent  
0819 1B0B              ;
0820 1B0B              ; This routine gets the current time in seconds from the internal routine and 
0821 1B0B              ; places it in the result...
0822 1B0B E2 30                 sep   #$30
0823 1B0D 22 8C 00 E1           jsl   ToReadTime
0824 1B11 C2 30                 rep   #$30
0825 1B13 90 04                 bcc   @GotTimeOK
0826 1B15              ;;;	ldx	#$2403
0827 1B15 A2 07 03              ldx   #$0307                   ;firmTaskErr (carry is already set) [DAL]
0828 1B18 60                    rts   
0829 1B19              @GotTimeOK  
0830 1B19 AF E1 03 E1           lda   >ClkRData
0831 1B1D 85 14                 sta   <Result
0832 1B1F AF E3 03 E1           lda   >ClkRData+2
0833 1B23 85 16                 sta   <Result+2
0834 1B25              ;;	ldx	#0	; flag no error and return
0835 1B25 18                    clc                            ;DAL
0836 1B26 60                    rts   
0837 1B27
0838 1B27              ;----------------------------------------------------------------------
0839 1B27              ;
0840 1B27              JustSetCurrent  
0841 1B27              ; This routine sets the current time to the seconds you passed
0842 1B27              ;
0843 1B27 A5 0E                 lda   theSecs
0844 1B29 8F E5 03 E1           sta   >ClkWData
0845 1B2D A5 10                 lda   theSecs+2
0846 1B2F 8F E7 03 E1           sta   >ClkWData+2
0847 1B33 E2 30                 sep   #$30
0848 1B35                       Longa Off
0849 1B35                       Longi Off
0850 1B35 8B                    phb                            ; save the old data bank
0851 1B36 A9 E1                 lda   #$E1                     ; and set proper bank for towritetime
0852 1B38 48                    pha   
0853 1B39 AB                    plb   
0854 1B3A 22 88 00 E1           jsl   ToWriteTime
0855 1B3E AB                    plb                            ; restore old data bank
0856 1B3F C2 30                 rep   #$30
0857 1B41                       Longa on
0858 1B41                       LongI on
0859 1B41              ;	ldx	#0
0860 1B41 18                    clc                            ;DAL
0861 1B42 60                    rts                            ; and finish
0862 1B43
0863 1B43              ;--------------------------------------------------------------------
0864 1B43              ;
0865 1B43              ToProDOS  
0866 1B43              ; This routine converts seconds to ProDOS8 time format
0867 1B43              ; It leverages off of the MTHex converter for its proper use...
0868 1B43              ;
0869 1B43 20 F0 20              jsr   ToMTHexFormat            ; get it in the MTHex format first...
0870 1B46              ; Time is now in misctools hex format, run it through the converter.
0871 1B46              ; its in [theDate] and must end up there...
0872 1B46 A0 01 00     ToProDOSFromMT ldy   #1
0873 1B49 B7 0A                 lda   [theDate],y              ; load the minutes/hours and save em
0874 1B4B 85 10                 sta   <theSecs+2               ; save as the high word of the seconds parameter
0875 1B4D C8                    iny   
0876 1B4E B7 0A                 lda   [theDate],y              ; get the year back...
0877 1B50 29 00 FF              and   #$FF00                   ; strip it off by itself
0878 1B53              *** ProDOS year 40..99 = 1940..1999, 0..39 = 2000..2039 (9-May-91 DAL)
0879 1B53              *** We have A=$xx00, where XX = year-100.  If this is less than 40, clip to 40.
0880 1B53              *** If this is more than 99, we need to subtract 100 and max out at 39.
0881 1B53 C9 00 28              cmp   #40*256
0882 1B56 90 12                 bcc   @clipTo1940
0883 1B58 C9 00 64              cmp   #100*256
0884 1B5B 90 10                 bcc   @yearIsFine
0885 1B5D E9 00 64              sbc   #100*256                 ;carry was already set
0886 1B60 C9 00 27              cmp   #39*256
0887 1B63 90 08                 bcc   @yearIsFine
0888 1B65 A9 00 27              lda   #39*256
0889 1B68 80 03                 bra   @yearIsFine
0890 1B6A
0891 1B6A A9 00 28     @clipTo1940 lda   #40*256
0892 1B6D              @yearIsFine  
0893 1B6D              *** end of 9-May-91 DAL
0894 1B6D 0A                    asl   a                        ; rotate it to the proper bit position
0895 1B6E 85 0E                 sta   <theSecs                 ; and save it...
0896 1B70 A0 04 00              ldy   #4
0897 1B73 B7 0A                 lda   [theDate],y              ; now get the day/month...
0898 1B75 AA                    tax                            ; save it for a second..
0899 1B76 29 1F 00              and   #$001F                   ; strip the day
0900 1B79 1A                    inc   a                        ; add 1 for good measure
0901 1B7A 05 0E                 ora   <theSecs                 ; add it to the year
0902 1B7C 85 0E                 sta   <theSecs                 ; and cache it again
0903 1B7E 8A                    txa   
0904 1B7F 29 00 0F              and   #$0F00                   ; strip the month off...
0905 1B82 EB                    xba   
0906 1B83 1A                    inc   a
0907 1B84 EB                    xba   
0908 1B85 4A                    lsr   a                        ; shift it over 3 bits right
0909 1B86 4A                    lsr   a                        ; shift it over 3 bits right
0910 1B87 4A                    lsr   a                        ; shift it over 3 bits right
0911 1B88 05 0E                 ora   <theSecs                 ; add it to the rest of the pdos date
0912 1B8A 87 0A                 sta   [theDate]                ; and put it in the returned record
0913 1B8C A0 02 00              ldy   #2
0914 1B8F A5 10                 lda   <theSecs+2
0915 1B91 97 0A                 sta   [theDate],y              ; now store the pdos time in the record
0916 1B93 18                    clc                            ; return no error (DAL)
0917 1B94 60                    rts   
0918 1B95
0919 1B95              ;--------------------------------------------------------------------
0920 1B95              ;
0921 1B95              FromProDOS  
0922 1B95              ; This routine takes a ProDOS formatted datetime record and converts it
0923 1B95              ; to seconds. To do this it first converts it to MTHex format then it
0924 1B95              ; calls fromMTHexFormat to finish the call...
0925 1B95              ;
0926 1B95
0927 1B95              ***	jsr	ToMTFromProDOS	; put it in MTHex format first
0928 1B95              ***	bra	FromMTHexFormat	; and now convert to to seconds
0929 1B95
0930 1B95              *** rewrite FromProDOS, 20-May-91 DAL
0931 1B95 48                    pha   
0932 1B96 48                    pha   
0933 1B97 A0 02 00              ldy   #2
0934 1B9A B7 0A                 lda   [<theDate],y
0935 1B9C 48                    pha   
0936 1B9D A7 0A                 lda   [<theDate]
0937 1B9F 48                    pha   
0938 1BA0 3B                    tsc   
0939 1BA1 1A                    inc   a
0940 1BA2 85 0A                 sta   <theDate
0941 1BA4 64 0C                 stz   <theDate+2               ;point <theDate at 8 bytes on the stack
0942 1BA6 20 B1 20              jsr   ToMTFromProDOS           ; put it in MTHex format first
0943 1BA9 20 12 21              jsr   FromMTHexFormat          ; and now convert to seconds
0944 1BAC 68                    pla   
0945 1BAD 68                    pla   
0946 1BAE 68                    pla   
0947 1BAF 68                    pla                            ;got rid of 8 temporary bytes
0948 1BB0 60                    rts                            ;return Carry status from FromMTHexFormat
0949 1BB1              *** end of 20-May-91 DAL
0950 1BB1
0951 1BB1 A0 02 00     ToMTFromProDOS ldy   #2                 ; first, suck up the timeword
0952 1BB4 B7 0A                 lda   [theDate],y              ; we now have the time word...
0953 1BB6 AA                    tax                            ; save it in <X> for now
0954 1BB7 A7 0A                 lda   [theDate]                ; now get the DateWord
0955 1BB9 85 12                 sta   <theVerb                 ; save the verb for a second
0956 1BBB A9 00 00              lda   #0                       ; be sure to set seconds to zero..
0957 1BBE 87 0A                 sta   [theDate]
0958 1BC0 88                    dey                            ; offset for MTHex Minutes/hours
0959 1BC1 8A                    txa                            ; get the minutes/hours back...
0960 1BC2 97 0A                 sta   [theDate],y              ; and save it
0961 1BC4 A5 12                 lda   <theVerb                 ; now extract the date data from ProDOS...
0962 1BC6 29 00 FE              and   #$FE00                   ; strip the year
0963 1BC9 4A                    lsr   a                        ; make it a proper year
0964 1BCA EB                    xba   
0965 1BCB
0966 1BCB              ;; Clamp for pre 1904 dates here!
0967 1BCB              ;	cmp	#4
0968 1BCB              ;	bge	@yrOK
0969 1BCB              ;	lda	#4
0970 1BCB              ;@YrOK
0971 1BCB              *** 9-May-91 DAL -- use new definition of 7-bit ProDOS year number (P8 Technical Note #28)
0972 1BCB              *** 40..99 = 1940..1999, 0..39 = 2000..2039
0973 1BCB C9 28 00              cmp   #40
0974 1BCE B0 03                 bcs   @yearOK
0975 1BD0 69 64 00              adc   #100
0976 1BD3              @yearOK   
0977 1BD3              *** end of 9-May-91 DAL
0978 1BD3
0979 1BD3 A0 03 00              ldy   #3                       ; offset to the MTHexYear
0980 1BD6 97 0A                 sta   [theDate],y              ; and stow the year...
0981 1BD8 A5 12                 lda   <theVerb
0982 1BDA 29 1F 00              and   #$001F                   ; strip the day off...
0983 1BDD 3A                    dec   a                        ; convertit to MTHex base
0984 1BDE C8                    iny   
0985 1BDF 97 0A                 sta   [theDate],y              ; and now save the day...
0986 1BE1 A5 12                 lda   <theVerb
0987 1BE3 29 E0 01              and   #$01E0                   ; finally strip the month..
0988 1BE6 0A                    asl   a                        ; rotate it over by 3
0989 1BE7 0A                    asl   a
0990 1BE8 0A                    asl   a                        ; (its now in bits 8-11)
0991 1BE9 EB                    xba                            ; put it in the low word...
0992 1BEA 3A                    dec   a
0993 1BEB C8                    iny   
0994 1BEC 97 0A                 sta   [theDate],y              ; and stow it..
0995 1BEE 18                    clc                            ;return no error (DAL)
0996 1BEF 60                    rts                            ; and simply return (Weekday not set by this routine)
0997 1BF0
0998 1BF0              ;--------------------------------------------------------------------
0999 1BF0              ;
1000 1BF0              ToMTHexFormat  
1001 1BF0              ; This routine converts the seconds to MiscTools HexFormat
1002 1BF0              ;
1003 1BF0 08                    php   
1004 1BF1 78                    sei                            ; turn off interupts
1005 1BF2 20 24 21              jsr   FudgeTimeVectors
1006 1BF5 20 7D 21              jsr   SetupToData
1007 1BF8 20 DE 21              jsr   CallReadHex              ; call readTimeHex
1008 1BFB 20 97 21              jsr   RestoreTimeVectors
1009 1BFE 28                    plp   
1010 1BFF 18                    clc                            ; for now, no errors
1011 1C00 60                    rts   
1012 1C01
1013 1C01              ;--------------------------------------------------------------------
1014 1C01              ;
1015 1C01              ToASCIITimeFormat  
1016 1C01              ; This routine converts the seconds to MiscTools HexFormat
1017 1C01              ;
1018 1C01 08                    php   
1019 1C02 78                    sei                            ; turn off interupts
1020 1C03 20 24 21              jsr   FudgeTimeVectors
1021 1C06 20 7D 21              jsr   SetupToData
1022 1C09 20 00 22              jsr   CallReadASCII            ; call readTimeHex
1023 1C0C 20 97 21              jsr   RestoreTimeVectors
1024 1C0F 28                    plp   
1025 1C10 18                    clc                            ;no error (DAL)
1026 1C11 60                    rts   
1027 1C12
1028 1C12              ;---------------------------------------------------------------------
1029 1C12              ;
1030 1C12              FromMTHexFormat  
1031 1C12              ; This routine converts from MTHexFormat to seconds...
1032 1C12              ;
1033 1C12 08                    php   
1034 1C13 78                    sei   
1035 1C14 20 24 21              jsr   FudgeTimeVectors
1036 1C17 20 0C 22              jsr   CallWriteHex
1037 1C1A 20 8A 21              jsr   SetUpFromData
1038 1C1D 20 97 21              jsr   RestoreTimeVectors
1039 1C20 28                    plp   
1040 1C21 18                    clc                            ; for now no errors!
1041 1C22 60                    rts   
1042 1C23
1043 1C23 60           TimeDummy rts   
1044 1C24              FudgeTimeVectors  
1045 1C24              ;
1046 1C24              ; First we patch both the toReadTime and toWriteTime vectors to do nothing but return
1047 1C24              ;
1048 1C24 AF 88 00 E1           lda   >ToWriteTime
1049 1C28 8F 31 22 02           sta   >OldWriteTime
1050 1C2C AF 8A 00 E1           lda   >ToWriteTime+2
1051 1C30 8F 33 22 02           sta   >OldWriteTime+2
1052 1C34 AF 8C 00 E1           lda   >ToReadTime
1053 1C38 8F 2D 22 02           sta   >OldReadTime
1054 1C3C AF 8E 00 E1           lda   >ToReadTime+2
1055 1C40 8F 2F 22 02           sta   >OldReadTime+2
1056 1C44
1057 1C44              ;; and save the old contents of ClockRTime and clockWTime
1058 1C44 AF E1 03 E1           lda   >CLKRDATA
1059 1C48 8F 35 22 02           sta   >savedRData
1060 1C4C AF E3 03 E1           lda   >CLKRDATA+2
1061 1C50 8F 37 22 02           sta   >savedRData+2
1062 1C54 AF E5 03 E1           lda   >CLKRDATA+4
1063 1C58 8F 39 22 02           sta   >savedRData+4
1064 1C5C AF E7 03 E1           lda   >CLKRDATA+6
1065 1C60 8F 3B 22 02           sta   >savedRData+6
1066 1C64
1067 1C64              ;
1068 1C64              ; Now patch in the new vectors, but first disable interupts...
1069 1C64
1070 1C64 AF DA 21 02           lda   >MyDummyRtn
1071 1C68 8F 88 00 E1           sta   >ToWriteTime
1072 1C6C 8F 8C 00 E1           sta   >ToReadTime
1073 1C70 AF DC 21 02           lda   >MyDummyRtn+2
1074 1C74 8F 8A 00 E1           sta   >ToWriteTime+2
1075 1C78 8F 8E 00 E1           sta   >toReadTime+2
1076 1C7C 60                    rts   
1077 1C7D
1078 1C7D A5 0E        SetUpToData lda   <theSecs
1079 1C7F 8F E1 03 E1           sta   >CLKRDATA
1080 1C83 A5 10                 lda   <theSecs+2
1081 1C85 8F E3 03 E1           sta   >CLKRDATA+2
1082 1C89 60                    rts   
1083 1C8A              ;	
1084 1C8A AF E5 03 E1  SetUpFromData lda   >CLKWData
1085 1C8E 85 14                 sta   <Result
1086 1C90 AF E7 03 E1           lda   >CLKWDATA+2
1087 1C94 85 16                 sta   <Result+2
1088 1C96 60                    rts   
1089 1C97
1090 1C97              RestoreTimeVectors  
1091 1C97 AF 35 22 02           lda   >SavedRData
1092 1C9B 8F E1 03 E1           sta   >CLKRDATA
1093 1C9F AF 37 22 02           lda   >SavedRData+2
1094 1CA3 8F E3 03 E1           sta   >CLKRDATA+2
1095 1CA7 AF 39 22 02           lda   >SavedRData+4
1096 1CAB 8F E5 03 E1           sta   >CLKRDATA+4
1097 1CAF AF 3B 22 02           lda   >SavedRData+6
1098 1CB3 8F E7 03 E1           sta   >CLKRDATA+6
1099 1CB7
1100 1CB7              ;; restore the old vectors...
1101 1CB7 AF 31 22 02           lda   >OldWriteTime
1102 1CBB 8F 88 00 E1           sta   >ToWriteTime
1103 1CBF AF 33 22 02           lda   >OldWriteTime+2
1104 1CC3 8F 8A 00 E1           sta   >ToWriteTime+2
1105 1CC7 AF 2D 22 02           lda   >OldReadTime
1106 1CCB 8F 8C 00 E1           sta   >ToReadTime
1107 1CCF AF 2F 22 02           lda   >OldReadTime+2
1108 1CD3 8F 8E 00 E1           sta   >ToReadTime+2
1109 1CD7 60                    rts   
1110 1CD8
1111 1CD8 18           MyDummyVector clc   
1112 1CD9 6B                    rtl   
1113 1CDA 5C D8 21 02  MyDummyRtn JML   MyDummyVector
1114 1CDE
1115 1CDE              ;; Routine to call read time HEX
1116 1CDE              CallReadHex  
1117 1CDE 48                    pha                            ; push on room for result
1118 1CDF 48                    pha   
1119 1CE0 48                    pha   
1120 1CE1 48                    pha   
1121 1CE2 A2 03 0D 22           _ReadTimeHex 
1122 1CE9 68                    pla   
1123 1CEA 87 0A                 sta   [theDate]
1124 1CEC 68                    pla   
1125 1CED A0 02 00              ldy   #2
1126 1CF0 97 0A                 sta   [theDate],y
1127 1CF2 68                    pla   
1128 1CF3 C8                    iny   
1129 1CF4 C8                    iny   
1130 1CF5 97 0A                 sta   [theDate],y
1131 1CF7 68                    pla   
1132 1CF8 C8                    iny   
1133 1CF9 C8                    iny   
1134 1CFA 29 00 FF              and   #$FF00                   ; make the null byte really zero!
1135 1CFD 97 0A                 sta   [theDate],y
1136 1CFF 60                    rts                            ; and end...
1137 1D00
1138 1D00              ;; Routine to call read time ASCII
1139 1D00              CallReadASCII  
1140 1D00 D4 0C                 pei   <theDate+2               ; push the pointer to our output buffer
1141 1D02 D4 0A                 pei   <theDate
1142 1D04 A2 03 0F 22           _ReadASCIITime 
1143 1D0B 60                    rts                            ; and end...
1144 1D0C
1145 1D0C              ; routine to call write time HEX
1146 1D0C              CallWriteHex  
1147 1D0C A0 04 00              ldy   #4
1148 1D0F B7 0A                 lda   [theDate],y
1149 1D11 48                    pha   
1150 1D12 88                    dey   
1151 1D13 88                    dey   
1152 1D14 B7 0A                 lda   [theDate],y
1153 1D16 C9 00 04              cmp   #$0400                   ; is the year less than 1904?
1154 1D19 B0 06                 bge   @YrOK                    ; nope, its OK
1155 1D1B 29 FF 00              and   #$00FF
1156 1D1E 09 00 04              ora   #$0400
1157 1D21              @YrOK     
1158 1D21 48                    pha   
1159 1D22 A7 0A                 lda   [theDate]
1160 1D24 48                    pha   
1161 1D25 A2 03 0E 22           _WriteTimeHex 
1162 1D2C 60                    rts   
1163 1D2D
1164 1D2D 00 00 00 00  oldReadTime DS L:1
1165 1D31 00 00 00 00  OldWriteTime DS L:1
1166 1D35 00 00 00 00  SavedRData DS L:2
1167 1D3D                       EndP 
1168 1D3D
1169 1D3D
1170 1D3D                       EJECT 
1171 1D3D              *******************************************************************************
1172 1D3D              *
1173 1D3D              * Description:      SysBeep2(beepType)
1174 1D3D              *
1175 1D3D              * New call 17-Sep-90 DAL
1176 1D3D              *
1177 1D3D              * Calls SendRequest to let anybody accepting requests decide what kind of sound
1178 1D3D              * to make, if any.
1179 1D3D              *
1180 1D3D              * If nobody accepts the request, then we do a regular SysBeep, or nothing,
1181 1D3D              * depending on bit 15 of the beepType.
1182 1D3D              *
1183 1D3D              * beepType:  bit 15: 1 = no sound if nobody accepts the request
1184 1D3D              *                    0 = SysBeep if nobody accepts the request
1185 1D3D              *            bit 14: 1 = do the beep on the next GetNextEvent
1186 1D3D              *                    0 = do it now
1187 1D3D              *            bits 13-0 = beep type
1188 1D3D              *
1189 1D3D              * Inputs:           beepType (word)
1190 1D3D              *
1191 1D3D              * Outputs:          None
1192 1D3D              *
1193 1D3D              * NOTE--This is used by the TS2 *and* TS3 files, so don't put any ROM-specific
1194 1D3D              *       stuff in this call!
1195 1D3D              *
1196 1D3D              *******************************************************************************
1197 1D3D              SysBeep2 PROC EXPORT 
1198 1D3D
1199 1D3D              beepType equ   7
1200 1D3D
1201 1D3D A3 07                 lda   beepType,s
1202 1D3F 29 00 40              and   #$4000                   ;the GetNextEvent flag
1203 1D42 F0 1E                 beq   @doItNow
1204 1D44
1205 1D44 F4 00 00              pea   0
1206 1D47 A2 06 06 22           _EMStatus 
1207 1D4E 68                    pla   
1208 1D4F F0 11                 beq   @doItNow
1209 1D51
1210 1D51 AF 7E 16 E1           lda   >PendingSysBeep2
1211 1D55 D0 09                 bne   @toExit                  ;already have one pending, ignore
1212 1D57 A3 07                 lda   beepType,s
1213 1D59 29 FF BF              and   #$BFFF                   ;mask out the GetNextEvent bit
1214 1D5C 8F 7E 16 E1           sta   >PendingSysBeep2
1215 1D60 80 7F        @toExit  bra   exit
1216 1D62
1217 1D62              @doItNow  
1218 1D62
1219 1D62              *** added 18-Jul-92 DAL -- Tell screen dimmers to bring back the real screen
1220 1D62 A3 07                 lda   beepType,s
1221 1D64 29 F0 3F              and   #$3ff0
1222 1D67 C9 60 00              cmp   #$0060                   ;006x = dim screen, undim screen
1223 1D6A F0 14                 beq   @noUndim
1224 1D6C A2 00 00              ldx   #0
1225 1D6F F4 0D 00              pea   $000D                    ;srqForceUndim
1226 1D72 DA                    phx                            ;sendToAll
1227 1D73 DA                    phx   
1228 1D74 DA                    phx                            ;target=NIL
1229 1D75 DA                    phx   
1230 1D76 DA                    phx                            ;dataIn=NIL
1231 1D77 DA                    phx   
1232 1D78 DA                    phx                            ;dataOut=NIL
1233 1D79 A2 01 1C 22           _SendRequest 
1234 1D80              @noUndim  
1235 1D80              *** end 18-Jul-92
1236 1D80
1237 1D80              *** Before broadcasting request, send to Sound Control Panel
1238 1D80 A3 07                 lda   beepType,s
1239 1D82 29 FF 3F              and   #$3fff
1240 1D85 F4 01 00              pea   1                        ;systemSaysBeep
1241 1D88 F4 01 80              pea   $8001                    ;stop after one, sendToName
1242 1D8B F4 02 00 F4           pushlong #SoundCPName 
1243 1D91 A2 00 00              ldx   #0
1244 1D94 DA                    phx                            ;dataIn high word (0)
1245 1D95 48                    pha                            ;dataIn low word (beepType)
1246 1D96 DA                    phx   
1247 1D97 DA                    phx                            ;dataOut = 0
1248 1D98 A2 01 1C 22           _SendRequest 
1249 1D9F 90 40                 bcc   exit
1250 1DA1
1251 1DA1 A3 07                 lda   beepType,s
1252 1DA3 29 FF 3F              and   #$3fff                   ;added 16-Oct-90 DAL
1253 1DA6 F4 01 00              pea   1                        ;systemSaysBeep
1254 1DA9 F4 00 80              pea   $8000                    ;How = stop after first acceptance
1255 1DAC A2 00 00              ldx   #0
1256 1DAF DA                    phx   
1257 1DB0 DA                    phx                            ;Target=nil
1258 1DB1 DA                    phx                            ;Data In high word = 0
1259 1DB2 48                    pha                            ;Data In low word = beepType
1260 1DB3 DA                    phx   
1261 1DB4 DA                    phx                            ;nil OutPtr
1262 1DB5 A2 01 1C 22           _SendRequest 
1263 1DBC 90 23                 bcc   exit
1264 1DBE
1265 1DBE A3 07                 lda   beepType,s
1266 1DC0 30 1F                 bmi   exit
1267 1DC2 C9 02 00              cmp   #2
1268 1DC5 F0 0C                 beq   @two
1269 1DC7 C9 03 00              cmp   #3
1270 1DCA D0 0E                 bne   @one
1271 1DCC A2 03 2C 22  @three   _SysBeep 
1272 1DD3 A2 03 2C 22  @two     _SysBeep 
1273 1DDA A2 03 2C 22  @one     _SysBeep 
1274 1DE1
1275 1DE1 A2 00 00     exit     ldx   #0                       ;error code = 0
1276 1DE4 A0 02 00              ldy   #2                       ;get rid of 2 bytes
1277 1DE7 5C 84 01 E1           jml   ToStrip
1278 1DEB
1279 1DEB 0E 41 70 70  SoundCPName DC B:14,'Apple~SoundCP~'
1280 1DFA
1281 1DFA                       EndP 
1282 1DFA
1283 1DFA
1284 1DFA              *******************************************************************************
1285 1DFA              *
1286 1DFA              * VersionString
1287 1DFA              *
1288 1DFA              * New call 5-Dec-90 DAL
1289 1DFA              *
1290 1DFA              * Description:      $3903 VersionString(flags,Version/4,@Buffer)
1291 1DFA              *
1292 1DFA              * flags = 0 (bits 15-0 reserved)
1293 1DFA              *
1294 1DFA              * Version = 32 bits:
1295 1DFA              *
1296 1DFA              *         _________________________________________________________________
1297 1DFA              * bit 31  |M|M|M|M|M|M|M|M|m|m|m|m|b|b|b|b|s|s|s|0|0|0|0|0|r|r|r|r|r|r|r|r|  bit 0
1298 1DFA              *         -----------------------------------------------------------------
1299 1DFA              *                         |               |               |
1300 1DFA              *
1301 1DFA              *           M = major version (2 digits, BCD)
1302 1DFA              *           m = minor version
1303 1DFA              *           b = bug version
1304 1DFA              *           s = stage (001=development, 010=alpha, 011=beta, 100=final, 101=released)
1305 1DFA              *           r = release (2 digits, BCD)
1306 1DFA              *
1307 1DFA              * Buffer points to a 10-character buffer to receive a Pascal string:
1308 1DFA              *   MM.m.bSrr
1309 1DFA              *
1310 1DFA              *******************************************************************************
1311 1DFA              VersionString proc export 
1312 1DFA
1313 1DFA              oldD     equ   1
1314 1DFA              rtl1     equ   oldD+2
1315 1DFA              rtl2     equ   rtl1+3
1316 1DFA              buffPtr  equ   rtl2+3
1317 1DFA              theVersion equ   buffPtr+4
1318 1DFA              theFlags equ   theVersion+4
1319 1DFA
1320 1DFA 0B                    phd   
1321 1DFB 3B                    tsc   
1322 1DFC 5B                    tcd   
1323 1DFD
1324 1DFD A9 00 00              lda   #0
1325 1E00 87 09                 sta   [buffPtr]
1326 1E02
1327 1E02 A5 10                 lda   theVersion+3             ;Major version byte
1328 1E04 20 62 23              jsr   DoVersByte
1329 1E07
1330 1E07 20 80 23              jsr   AppendDot
1331 1E0A A5 0F                 lda   theVersion+2             ;minor version
1332 1E0C 20 5D 23              jsr   LSR4
1333 1E0F 20 6A 23              jsr   DoVersNibble
1334 1E12
1335 1E12 A5 0F                 lda   theVersion+2             ;bug version
1336 1E14 29 0F 00              and   #$000f
1337 1E17 F0 08                 beq   @noBug
1338 1E19 20 80 23              jsr   AppendDot
1339 1E1C A5 0F                 lda   theVersion+2
1340 1E1E 20 6A 23              jsr   DoVersNibble
1341 1E21              @noBug    
1342 1E21
1343 1E21 A5 0D                 lda   theVersion
1344 1E23 C9 00 A0              cmp   #$A000                   ;stage = 101
1345 1E26 F0 22                 beq   @released
1346 1E28
1347 1E28 A5 0E                 lda   theVersion+1
1348 1E2A 29 1F 00              and   #$001f                   ;reserved bits
1349 1E2D F0 05                 beq   @valid
1350 1E2F A9 00 00              lda   #0
1351 1E32 80 09                 bra   @WeirdStage
1352 1E34
1353 1E34 A5 0E        @Valid   lda   theVersion+1
1354 1E36 29 E0 00              and   #$00e0
1355 1E39 20 5D 23              jsr   LSR4
1356 1E3C 4A                    lsr   a
1357 1E3D AA           @WeirdStage tax   
1358 1E3E BF 55 23 02           lda   >StageCharacters,x
1359 1E42 20 83 23              jsr   AppendChar
1360 1E45 A5 0D                 lda   theVersion
1361 1E47 20 62 23              jsr   DoVersByte
1362 1E4A
1363 1E4A 2B           @released pld   
1364 1E4B A2 00 00              ldx   #0                       ;error code = 0
1365 1E4E A0 0A 00              ldy   #10                      ;strip 10 bytes
1366 1E51 5C 84 01 E1           jml   ToStrip
1367 1E55
1368 1E55 3F 64 61 62  StageCharacters DC B:'?dabf???'
1369 1E5D
1370 1E5D 4A           LSR4     lsr   a
1371 1E5E 4A                    lsr   a
1372 1E5F 4A                    lsr   a
1373 1E60 4A                    lsr   a
1374 1E61 60                    rts   
1375 1E62
1376 1E62 48           DoVersByte pha   
1377 1E63 20 5D 23              jsr   LSR4
1378 1E66 20 7A 23              jsr   AppendNotZero
1379 1E69 68                    pla   
1380 1E6A 29 0F 00     DoVersNibble and   #$000f
1381 1E6D 09 30 00              ora   #'0'
1382 1E70 C9 3A 00              cmp   #'9'+1
1383 1E73 90 0E                 bcc   AppendChar
1384 1E75 A9 3F 00              lda   #'?'
1385 1E78 80 09                 bra   AppendChar
1386 1E7A
1387 1E7A 29 0F 00     AppendNotZero and   #$000f
1388 1E7D D0 EB                 bne   DoVersNibble
1389 1E7F 60                    rts   
1390 1E80
1391 1E80 A9 2E 00     AppendDot lda   #'.'
1392 1E83 E2 30        AppendChar sep   #$30
1393 1E85 48                    pha   
1394 1E86 A7 09                 lda   [buffPtr]
1395 1E88 1A                    inc   a
1396 1E89 87 09                 sta   [buffPtr]
1397 1E8B A8                    tay   
1398 1E8C 68                    pla   
1399 1E8D 97 09                 sta   [buffPtr],y
1400 1E8F C2 30                 rep   #$30
1401 1E91 60                    rts   
1402 1E92
1403 1E92                       EndP 
1404 1E92
1405 1E92              *******************************************************************************
1406 1E92              *
1407 1E92              * WaitUntil
1408 1E92              *
1409 1E92              * New call 6-Jan-91 DAL
1410 1E92              *
1411 1E92              * Description:      $3A03  WaitUntil(WaitFromTime,DelayTime) --> returns NewTime
1412 1E92              *
1413 1E92              * WaitUntil is used for putting a maximum speed on repeated actions that the
1414 1E92              * user can see.  (For example, menu item blinking, blinking a control in response
1415 1E92              * to a keypress, continuous scrolling, and zoom-rect effects.)
1416 1E92              *
1417 1E92              * Time specifies the time to wait *from*.  Zero means to wait from the
1418 1E92              * current time.  Other values should come from previous calls to WaitUntil.
1419 1E92              *
1420 1E92              * DelayTime specifies how long to wait from WaitFromTime, in units of approximately
1421 1E92              * 1/16 of a tick.  Zero means to return right away, giving a valid NewTime value.
1422 1E92              *
1423 1E92              * WaitUntil multiplies the delay time by BRAM location $60 minus 1, unless the
1424 1E92              * location is $00 or $FF (defaults for ROM 1 and ROM 3).  The wait maxxes out
1425 1E92              * at $F00 ticks (64 seconds) to avoid wrap-around problems.
1426 1E92              *
1427 1E92              *******************************************************************************
1428 1E92              WaitUntil proc export 
1429 1E92
1430 1E92              oldD     equ   1
1431 1E92              rtl1     equ   oldD+2
1432 1E92              rtl2     equ   rtl1+3
1433 1E92              DelayTime equ   rtl2+3
1434 1E92              WaitFromTime equ   DelayTime+2
1435 1E92              NewTime  equ   WaitFromTime+2
1436 1E92
1437 1E92 0B                    phd   
1438 1E93 3B                    tsc   
1439 1E94 5B                    tcd   
1440 1E95
1441 1E95              * If interrupts are disabled, get out of here.
1442 1E95
1443 1E95 64 0D                 stz   <NewTime
1444 1E97 08                    php   
1445 1E98 08                    php   
1446 1E99 68                    pla   
1447 1E9A 29 04 00              and   #4                       ;Interrupts disabled?
1448 1E9D D0 47                 bne   Exit
1449 1E9F
1450 1E9F              * Multiply DelayTime based on battery-RAM location
1451 1E9F
1452 1E9F 48                    pha   
1453 1EA0 F4 60 00              pea   $60
1454 1EA3 A2 03 0C 22           _ReadBParam 
1455 1EAA 68                    pla   
1456 1EAB F0 20                 beq   @noMultiply
1457 1EAD C9 FF 00              cmp   #$00ff
1458 1EB0 F0 1B                 beq   @noMultiply
1459 1EB2
1460 1EB2 48                    pha   
1461 1EB3 48                    pha                            ;result space for _Multiply
1462 1EB4 3A                    dec   a                        ;BRAM value - 1
1463 1EB5 48                    pha   
1464 1EB6 D4 09                 pei   <DelayTime
1465 1EB8 A2 0B 09 22           _Multiply 
1466 1EBF 68                    pla   
1467 1EC0 FA                    plx   
1468 1EC1 D0 05                 bne   @maxtime
1469 1EC3 C9 00 F0              cmp   #$f000
1470 1EC6 90 03                 bcc   @storeTime
1471 1EC8 A9 00 F0     @maxtime lda   #$f000                   ;don't get too big, or we'll delay by accident
1472 1ECB 85 09        @storeTime sta   <DelayTime
1473 1ECD
1474 1ECD              @noMultiply  
1475 1ECD              * If WaitFromTime is 0, use the current time.
1476 1ECD A5 0B                 lda   <WaitFromTime
1477 1ECF D0 05                 bne   @haveFromTime
1478 1ED1 20 F1 23              jsr   GetTime
1479 1ED4 85 0B                 sta   <WaitFromTime
1480 1ED6              @haveFromTime  
1481 1ED6
1482 1ED6 20 F1 23     @wait    jsr   GetTime
1483 1ED9 A8                    tay   
1484 1EDA D0 01                 bne   @1
1485 1EDC 1A                    inc   a
1486 1EDD 85 0D        @1       sta   <NewTime                 ;never return NewTime=0
1487 1EDF
1488 1EDF 38                    sec   
1489 1EE0 E5 0B                 sbc   <WaitFromTime
1490 1EE2 C5 09                 cmp   <DelayTime
1491 1EE4 90 F0                 bcc   @wait
1492 1EE6
1493 1EE6 2B           Exit     pld   
1494 1EE7 A2 00 00              ldx   #0                       ;error code = 0
1495 1EEA A0 04 00              ldy   #4                       ;strip 4 bytes of input parameters
1496 1EED 5C 84 01 E1           jml   ToStrip
1497 1EF1
1498 1EF1              *
1499 1EF1              * GetTime--return A = Now in 16ths of a tick
1500 1EF1              *
1501 1EF1              * For now, we just use the tick count.  Can be improved later.
1502 1EF1              *
1503 1EF1 48           GetTime  pha   
1504 1EF2 48                    pha   
1505 1EF3 A2 03 25 22           _GetTick 
1506 1EFA 68                    pla   
1507 1EFB 7A                    ply   
1508 1EFC 0A                    asl   a
1509 1EFD 0A                    asl   a
1510 1EFE 0A                    asl   a
1511 1EFF 0A                    asl   a
1512 1F00 60                    rts   
1513 1F01
1514 1F01                       EndP 
1515 1F01
1516 1F01
1517 1F01              *******************************************************************************
1518 1F01              *
1519 1F01              * $3B03 StringToText -- new call 4-Mar-91 DAL
1520 1F01              *
1521 1F01              * Inputs:  WORD  space for result flags
1522 1F01              *          WORD  space for result length
1523 1F01              *          WORD  input flags
1524 1F01              *          LONG  pointer to input text
1525 1F01              *          WORD  length of input text
1526 1F01              *          LONG  pointer to result buffer (GS/OS result buffer)
1527 1F01              *
1528 1F01              * The output buffer is a GS/OS result buffer:
1529 1F01              *   +000: buffer size (including the header fields)
1530 1F01              *   +002: data length
1531 1F01              *   +004: the actual data (up to buffer-size minus 4 bytes)
1532 1F01              *
1533 1F01              * The Flags input word:
1534 1F01              *   bit 15: allow mousetext in result
1535 1F01              *   bit 14: allow multi-character substitutions into result
1536 1F01              *   bit 13: force language number (bits 2..0)
1537 1F01              *   bit 12: translate weird characters to self instead of to null
1538 1F01              *   bits 11-3: reserved (must be 0)
1539 1F01              *   bits 2-0: language number
1540 1F01              *      0=USA, 1=UK, 2=French, 3=Danish, 4=Spanish, 5=Italian,
1541 1F01              *      6=German, 7=Swedish (just like bits 7-5 of $C02B)
1542 1F01              *
1543 1F01              * The ResultFlags word:
1544 1F01              *   bit 15: 1=changes were made to the string, 0=no changes
1545 1F01              *   bits 14-0: reserved (ignore)
1546 1F01              *
1547 1F01              *******************************************************************************
1548 1F01              StringToText proc export 
1549 1F01 8B                    phb   
1550 1F02 4B                    phk   
1551 1F03 AB                    plb   
1552 1F04 0B                    phd   
1553 1F05 48                    pha   
1554 1F06 48                    pha                            ;space for @out
1555 1F07 48                    pha                            ;space for @spaceLeft
1556 1F08 48                    pha                            ;space for @language
1557 1F09 A9 00 00              lda   #0
1558 1F0C 48                    pha   
1559 1F0D 48                    pha                            ;space/value for @sourceHandle
1560 1F0E 3B                    tsc   
1561 1F0F 5B                    tcd   
1562 1F10
1563 1F10              @sourceHandle equ   1
1564 1F10              @language equ   @sourceHandle+4
1565 1F10              @spaceLeft equ   @language+2
1566 1F10              @out     equ   @spaceLeft+2
1567 1F10              @oldB    equ   @out+4
1568 1F10              @oldD    equ   @oldB+1
1569 1F10              @rtl     equ   @oldD+2
1570 1F10              @OutBuff equ   @rtl+6
1571 1F10              @inputLen equ   @OutBuff+4
1572 1F10              @input   equ   @inputLen+2
1573 1F10              @flags   equ   @input+4
1574 1F10              @PrintLength equ   @flags+2
1575 1F10              @ResultFlags equ   @PrintLength+2       ;added 15-Apr-91 DAL
1576 1F10
1577 1F10 64 22                 stz   @PrintLength             ;start with printable length = 0
1578 1F12 64 24                 stz   @ResultFlags
1579 1F14
1580 1F14              *** If source is inside output buffer, put it somewhere safe
1581 1F14 38                    sec   
1582 1F15 A5 1C                 lda   <@input
1583 1F17 E5 16                 sbc   <@outBuff
1584 1F19 AA                    tax   
1585 1F1A A5 1E                 lda   <@input+2
1586 1F1C E5 18                 sbc   <@outBuff+2
1587 1F1E 90 46                 bcc   @alreadySafe             ;input<outbuff -- no overlap
1588 1F20 D0 44                 bne   @alreadySafe             ;input-outbuff > 64K -- no overlap
1589 1F22 8A                    txa   
1590 1F23 C7 16                 cmp   [@outBuff]               ;input-outbuff > buffsize -- no overlap
1591 1F25 B0 3F                 bcs   @alreadySafe
1592 1F27
1593 1F27 48                    pha   
1594 1F28 48                    pha                            ;space for NewHandle result
1595 1F29 F4 00 00              pea   0
1596 1F2C D4 1A                 pei   <@inputLen               ;size needed
1597 1F2E F4 03 40              pea   $4003                    ;memory ID
1598 1F31 F4 00 80              pea   $8000                    ;attributes (locked)
1599 1F34 48                    pha   
1600 1F35 48                    pha   
1601 1F36 A2 02 09 22           _NewHandle 
1602 1F3D AA                    tax   
1603 1F3E 7A                    ply   
1604 1F3F 68                    pla   
1605 1F40 90 03                 bcc   @nhOK
1606 1F42 82 9B 00              brl   @exit
1607 1F45 85 03        @nhOK    sta   <@sourceHandle+2
1608 1F47 84 01                 sty   <@sourceHandle
1609 1F49
1610 1F49 D4 1E                 pei   <@input+2
1611 1F4B D4 1C                 pei   <@input
1612 1F4D 48                    pha                            ;AY is still <@sourceHandle
1613 1F4E 5A                    phy   
1614 1F4F F4 00 00              pea   0
1615 1F52 D4 1A                 pei   <@inputLen
1616 1F54 A2 02 28 22           _PtrToHand 
1617 1F5B
1618 1F5B A0 02 00              ldy   #2
1619 1F5E B7 01                 lda   [<@sourceHandle],y
1620 1F60 85 1E                 sta   <@input+2
1621 1F62 A7 01                 lda   [<@sourceHandle]
1622 1F64 85 1C                 sta   <@input
1623 1F66              @alreadySafe  
1624 1F66
1625 1F66 A7 16                 lda   [@OutBuff]
1626 1F68 38                    sec   
1627 1F69 E9 04 00              sbc   #4
1628 1F6C 85 07                 sta   @spaceLeft
1629 1F6E 90 5F                 bcc   @tooSmall
1630 1F70
1631 1F70              *** Zero out the data size word in the result buffer
1632 1F70 A0 02 00              ldy   #2
1633 1F73 A9 00 00              lda   #0
1634 1F76 97 16                 sta   [@outBuff],y
1635 1F78
1636 1F78              *** start by assuming the language we want is what the character generator
1637 1F78              *** is already using (bits 7-5 of LANGSEL, $C02B)
1638 1F78 AF 2B C0 E0           lda   >$E0C02B
1639 1F7C 29 E0 00              and   #$00E0
1640 1F7F 4A                    lsr   a
1641 1F80 4A                    lsr   a
1642 1F81 4A                    lsr   a
1643 1F82 4A                    lsr   a
1644 1F83 4A                    lsr   a
1645 1F84 85 05                 sta   <@language
1646 1F86
1647 1F86              *** Check for pass-through flag
1648 1F86 A5 20                 lda   <@flags
1649 1F88 29 00 10              and   #$1000
1650 1F8B 8D 44 2A              sta   passThruFlag
1651 1F8E 14 20                 trb   <@flags                  ;clear bit 12 in <@flags
1652 1F90
1653 1F90 A5 20                 lda   <@flags
1654 1F92 29 00 20              and   #$2000                   ;bit 13 forces language number
1655 1F95 F0 07                 beq   @noForceLang
1656 1F97 A5 20                 lda   <@flags
1657 1F99 29 07 00              and   #7
1658 1F9C 85 05                 sta   <@language
1659 1F9E              @noForceLang  
1660 1F9E
1661 1F9E              *** clear all the unwanted flag bits
1662 1F9E A9 FF 3F              lda   #$3FFF
1663 1FA1 14 20                 trb   <@flags
1664 1FA3
1665 1FA3              *** @out = @OutBuff+4 (point to first result byte in the buffer)
1666 1FA3 A6 18                 ldx   <@OutBuff+2
1667 1FA5 A5 16                 lda   <@OutBuff
1668 1FA7 18                    clc   
1669 1FA8 69 04 00              adc   #4
1670 1FAB 85 09                 sta   <@out
1671 1FAD 90 01                 bcc   @1
1672 1FAF E8                    inx   
1673 1FB0 86 0B        @1       stx   <@out+2
1674 1FB2
1675 1FB2 A5 1A                 lda   <@inputLen
1676 1FB4 F0 14                 beq   @storeLengthNoErr
1677 1FB6 A7 1C        @CharLoop lda   [<@input]
1678 1FB8 29 FF 00              and   #$00ff
1679 1FBB 20 1C 25              jsr   @EmitTranslation
1680 1FBE B0 0F                 bcs   @tooSmall
1681 1FC0 E6 1C                 inc   <@input
1682 1FC2 D0 02                 bne   @2
1683 1FC4 E6 1E                 inc   <@input+2
1684 1FC6 C6 1A        @2       dec   <@inputLen
1685 1FC8 D0 EC                 bne   @CharLoop
1686 1FCA
1687 1FCA A2 00 00     @storeLengthNoErr ldx   #0
1688 1FCD 80 03                 bra   @storeLength
1689 1FCF
1690 1FCF A2 4F 03     @tooSmall ldx   #$034F
1691 1FD2
1692 1FD2 38           @storeLength sec                        ;error in X
1693 1FD3 A5 09                 lda   @out
1694 1FD5 E5 16                 sbc   @outBuff
1695 1FD7 38                    sec   
1696 1FD8 E9 04 00              sbc   #4
1697 1FDB A0 02 00              ldy   #2
1698 1FDE 97 16                 sta   [<@outBuff],y
1699 1FE0
1700 1FE0              @exit     
1701 1FE0              *** kill sourceHandle if we allocated one
1702 1FE0 DA                    phx   
1703 1FE1 A5 02                 lda   <@sourceHandle+1
1704 1FE3 F0 0B                 beq   @noSourceHandle
1705 1FE5 D4 03                 pei   <@sourceHandle+2
1706 1FE7 D4 01                 pei   <@sourceHandle
1707 1FE9 A2 02 10 22           _DisposeHandle 
1708 1FF0 FA           @noSourceHandle plx   
1709 1FF1
1710 1FF1 68                    pla   
1711 1FF2 68                    pla                            ;removed @sourceHandle
1712 1FF3 68                    pla                            ;removed @language
1713 1FF4 68                    pla                            ;removed @spaceLeft
1714 1FF5 68                    pla   
1715 1FF6 68                    pla                            ;removed @out
1716 1FF7 2B                    pld                            ;error in X
1717 1FF8 AB                    plb   
1718 1FF9 A0 0C 00              ldy   #12                      ;strip 12 bytes of input parameters
1719 1FFC 5C 84 01 E1           jml   $e10184                  ;ToStrip
1720 2000
1721 2000              *******************************************************************************
1722 2000              *
1723 2000              * EmitCharacter
1724 2000              *
1725 2000              * Input: Character in A
1726 2000              *
1727 2000              * Output: Decrements @spaceLeft, increments @Out
1728 2000              *
1729 2000              *******************************************************************************
1730 2000 38           @EmitCharacter sec   
1731 2001 A6 07                 ldx   @spaceLeft
1732 2003 F0 16                 beq   @full
1733 2005 C6 07                 dec   @spaceLeft
1734 2007 E2 20                 sep   #$20
1735 2009 87 09                 sta   [@Out]
1736 200B C2 20                 rep   #$20
1737 200D E6 09                 inc   @Out
1738 200F D0 02                 bne   @ok
1739 2011 E6 0B                 inc   @Out+2
1740 2013 C9 20 00     @ok      cmp   #$0020                   ;printable character?
1741 2016 90 02                 bcc   @noPrint
1742 2018 E6 22                 inc   @PrintLength
1743 201A 18           @noPrint clc   
1744 201B 60           @full    rts   
1745 201C
1746 201C              *******************************************************************************
1747 201C              *
1748 201C              * EmitTranslation -- translate a single character
1749 201C              *
1750 201C              * Inputs: A = character to translate
1751 201C              *         @Language = language number
1752 201C              *         @Flags: bit 15 = allow mousetext, 14 = allow expansion
1753 201C              *
1754 201C              * Updates: @Out, @spaceLeft, @PrintLength
1755 201C              *
1756 201C              * Output: Returns SEC if the output buffer is full
1757 201C              *
1758 201C              *******************************************************************************
1759 201C              @EmitTranslation  
1760 201C
1761 201C              *** Before we dive into the big table, let's weed out big ranges.
1762 201C              *** If bit 7 is on or it's one of the characters that gets remapped
1763 201C              *** across display languages or it's a control character, go for the
1764 201C              *** table.  Otherwise emit it as-is, as a printable character.
1765 201C
1766 201C C9 7B 00              cmp   #$007b
1767 201F B0 1E                 bcs   @useTable
1768 2021 C9 61 00              cmp   #$0061
1769 2024 B0 DA                 bcs   @EmitCharacter
1770 2026 C9 5B 00              cmp   #$005B
1771 2029 B0 14                 bcs   @useTable
1772 202B C9 41 00              cmp   #$0041
1773 202E B0 D0                 bcs   @EmitCharacter
1774 2030 C9 23 00              cmp   #$0023
1775 2033 F0 0A                 beq   @useTable
1776 2035 C9 40 00              cmp   #$0040
1777 2038 F0 05                 beq   @useTable
1778 203A C9 20 00              cmp   #$20
1779 203D B0 C1                 bcs   @EmitCharacter
1780 203F              ;fall into @useTable
1781 203F
1782 203F              *******************************************************************************
1783 203F              *
1784 203F              * @useTable -- emit the translation for the character in A
1785 203F              *
1786 203F              *******************************************************************************
1787 203F E2 20        @useTable sep   #$20                    ;16-Jan-92 DAL
1788 2041 8D D4 25              sta   XlateTable
1789 2044 C2 20                 rep   #$20                     ;16-Jan-92 DAL
1790 2046 A2 C0 03              ldx   #XlateEnd-XlateTable
1791 2049 AD D4 25     @resumeSearch lda   XlateTable
1792 204C CA           @search  dex   
1793 204D CA                    dex   
1794 204E CA                    dex   
1795 204F CA                    dex   
1796 2050 CA                    dex   
1797 2051 E2 20                 sep   #$20
1798 2053 DD D4 25              cmp   XlateTable,x
1799 2056 C2 20                 rep   #$20
1800 2058
1801 2058 D0 F2                 bne   @search
1802 205A              *** If there are bits set in the translation flags that aren't in the caller's
1803 205A              *** flags, then this translation is no good, keep looking (mousetext or expansion)
1804 205A A5 20                 lda   @flags
1805 205C 49 00 C0              eor   #$C000                   ;top 2 bits
1806 205F 3D D5 25              and   XlateTable+1,x           ;16-Jan-92 DAL
1807 2062 D0 E5                 bne   @resumeSearch
1808 2064              *** If this translation is for a particular language, make sure it's the one we need
1809 2064 BD D5 25              lda   XlateTable+1,x           ;16-Jan-92 DAL
1810 2067 29 00 20              and   #$2000                   ;one language?
1811 206A F0 0A                 beq   @match
1812 206C BD D5 25              lda   XlateTable+1,x           ;16-Jan-92 DAL
1813 206F 29 07 00              and   #7
1814 2072 C5 05                 cmp   @language
1815 2074 D0 D3                 bne   @resumeSearch
1816 2076
1817 2076 BD D7 25     @match   lda   XlateTable+3,x           ;translation	;16-Jan-92 DAL
1818 2079 F0 31                 beq   @null
1819 207B 1A                    inc   a
1820 207C F0 43                 beq   @default
1821 207E 3A                    dec   a
1822 207F AA                    tax   
1823 2080
1824 2080              *** Set the Changed result-flag bit if it's changing
1825 2080 AD D4 25              lda   XlateTable
1826 2083 29 FF 00              and   #$00ff                   ;16-Jan-92 DAL
1827 2086 EB                    xba   
1828 2087 1A                    inc   a                        ;A = $cc01
1829 2088 DD 00 00              cmp   |0,x
1830 208B F0 05                 beq   @noChange                ;substitution string exactly matches input character!
1831 208D
1832 208D A9 00 80              lda   #$8000
1833 2090 04 24                 tsb   <@ResultFlags
1834 2092              @noChange  
1835 2092
1836 2092 BD 00 00              lda   |0,x
1837 2095 29 FF 00              and   #$00ff
1838 2098 A8                    tay                            ;number of characters in translation
1839 2099 E8           @emitMultiple inx   
1840 209A BD 00 00              lda   |0,x
1841 209D 29 FF 00              and   #$00ff
1842 20A0 DA                    phx   
1843 20A1 20 00 25              jsr   @EmitCharacter
1844 20A4 FA                    plx   
1845 20A5 B0 04                 bcs   @oopsFull
1846 20A7 88                    dey   
1847 20A8 D0 EF                 bne   @emitMultiple
1848 20AA
1849 20AA 18                    clc   
1850 20AB 60           @oopsFull rts   
1851 20AC
1852 20AC              @null     
1853 20AC              *** If passThruFlag is set, emit the character
1854 20AC AD 44 2A              lda   passThruFlag
1855 20AF F0 09                 beq   @oldWay
1856 20B1 AD D4 25              lda   XlateTable
1857 20B4 29 FF 00              and   #$00ff
1858 20B7 82 46 FF              brl   @EmitCharacter
1859 20BA              @oldWay   
1860 20BA A9 00 80              lda   #$8000                   ;15-Apr-91 DAL
1861 20BD 04 24                 tsb   <@resultFlags
1862 20BF 18                    clc   
1863 20C0 60                    rts   
1864 20C1
1865 20C1              *
1866 20C1              * @default -- character not in table, so emit it if it's printable
1867 20C1              *
1868 20C1 AD D4 25     @default lda   XlateTable               ;get the character back
1869 20C4 29 FF 00              and   #$00ff
1870 20C7 C9 80 00              cmp   #$0080
1871 20CA B0 E0                 bcs   @null
1872 20CC C9 20 00              cmp   #$0020
1873 20CF 90 DB                 bcc   @null
1874 20D1 82 2C FF              brl   @EmitCharacter
1875 20D4
1876 20D4              *******************************************************************************
1877 20D4              *
1878 20D4              * XlateTable
1879 20D4              *
1880 20D4              * 5 bytes per translation entry:
1881 20D4              *   +000: source character (byte)
1882 20D4              *   +001: flags (15=MouseText, 14=expands, 13=one language only)
1883 20D4              *   +003: pointer to replacement string (0=replace with null string, $FFFF=not found)
1884 20D4              *
1885 20D4              * Note that the table is searched from end to beginning, so higher-precedence
1886 20D4              * translations must come later in the table.
1887 20D4              *
1888 20D4              *******************************************************************************
1889 20D4
1890 20D4 77 00 00 FF  XlateTable trans $77,$0000,$FFFF        ;character, flags, replace
1891 20D9
1892 20D9              *** generic foreign characters and other
1893 20D9              *** last-resort things (must be searched after foreign language stuff)
1894 20D9 7F 00 00 00           trans $7F,$0000,$0000          ;kill DELs
1895 20DE 80 00 00 E6           trans $80,$0000,aBigA          ;umlat A
1896 20E3 81 00 00 E6           trans $81,$0000,aBigA          ;angstrom A
1897 20E8 82 00 00 EB           trans $82,$0000,aBigC          ;cedilla C
1898 20ED 83 00 00 ED           trans $83,$0000,aBigE          ;accent E
1899 20F2 84 00 00 EF           trans $84,$0000,aBigN          ;tilde N
1900 20F7 85 00 00 F1           trans $85,$0000,aBigO          ;umlat O
1901 20FC 86 00 00 F3           trans $86,$0000,aBigU          ;umlat U
1902 2101 87 00 00 D4           trans $87,$0000,aSmallA        ;accent a
1903 2106 88 00 00 D4           trans $88,$0000,aSmallA        ;grave a
1904 210B 89 00 00 D4           trans $89,$0000,aSmallA        ;hat a
1905 2110 8A 00 00 D4           trans $8A,$0000,aSmallA        ;umlat a
1906 2115 8B 00 00 D4           trans $8B,$0000,aSmallA        ;tilde a
1907 211A 8C 00 00 D4           trans $8C,$0000,aSmallA        ;angstrom a
1908 211F 8D 00 00 D6           trans $8D,$0000,asmallC        ;cedilla c
1909 2124 8E 00 00 D8           trans $8E,$0000,aSmallE        ;accent e
1910 2129 8F 00 00 D8           trans $8F,$0000,aSmallE        ;grave e
1911 212E 90 00 00 D8           trans $90,$0000,aSmallE        ;hat e
1912 2133 91 00 00 D8           trans $91,$0000,aSmallE        ;umlat e
1913 2138 92 00 00 DC           trans $92,$0000,aSmalli        ;accent i
1914 213D 93 00 00 DC           trans $93,$0000,aSmalli        ;grave i
1915 2142 94 00 00 DC           trans $94,$0000,aSmalli        ;hat i
1916 2147 95 00 00 DC           trans $95,$0000,aSmalli        ;umlat i
1917 214C 96 00 00 DE           trans $96,$0000,aSmallN        ;tilde n
1918 2151 97 00 00 E0           trans $97,$0000,aSmallO        ;accent o
1919 2156 98 00 00 E0           trans $98,$0000,aSmallO        ;grave o
1920 215B 99 00 00 E0           trans $99,$0000,aSmallO        ;hat o
1921 2160 9A 00 00 E0           trans $9A,$0000,aSmallO        ;umlat o
1922 2165 9B 00 00 E0           trans $9B,$0000,aSmallO        ;tilde o
1923 216A 9C 00 00 E2           trans $9C,$0000,aSmallU        ;accent u
1924 216F 9D 00 00 E2           trans $9D,$0000,aSmallU        ;grave u
1925 2174 9E 00 00 E2           trans $9E,$0000,aSmallU        ;hat u
1926 2179 9F 00 00 E2           trans $9F,$0000,aSmallU        ;umlat u
1927 217E A7 00 40 E8           trans $A7,$4000,aSmallSS       ;german "§" --> "ss" (21-Jan-92 DAL)
1928 2183 AE 00 40 F8           trans $AE,$4000,aBigAE         ;AE
1929 2188 AF 00 00 26           trans $AF,$0000,aZero          ;big PHI
1930 218D BE 00 40 F5           trans $BE,$4000,aSmallAE       ;ae
1931 2192 BF 00 00 26           trans $BF,$0000,aZero          ;small PHI
1932 2197 C0 00 00 D0           trans $C0,$0000,aQuestion      ;"À"
1933 219C C1 00 00 D2           trans $C1,$0000,aBang          ;"Á"
1934 21A1 C9 00 40 01           trans $C9,$4000,anEllipsis     ;"É"
1935 21A6 CB 00 00 E6           trans $CB,$0000,aBigA          ;grave A
1936 21AB CC 00 00 E6           trans $CC,$0000,aBigA          ;tilde A
1937 21B0 CD 00 00 F1           trans $CD,$0000,aBigO          ;tilde O
1938 21B5 CE 00 40 FE           trans $CE,$4000,aBigOE         ;OE
1939 21BA CF 00 40 FB           trans $CF,$4000,aSmallOE       ;oe
1940 21BF D8 00 00 E4           trans $D8,$0000,aSmallY        ;umlat y
1941 21C4
1942 21C4              *** Translate unclaimed #, @, [, backsl, ], {, |, }, ~ (but not grave accent)
1943 21C4 23 00 00 00           trans $23,$0000,$0000 
1944 21C9 40 00 00 00           trans $40,$0000,$0000 
1945 21CE 5B 00 00 C1           trans $5B,$0000,aLeftParen 
1946 21D3 5C 00 00 00           trans $5C,$0000,$0000 
1947 21D8 5D 00 00 C3           trans $5D,$0000,aRightParen 
1948 21DD 7B 00 00 C1           trans $7B,$0000,aLeftParen 
1949 21E2 7C 00 00 00           trans $7C,$0000,$0000 
1950 21E7 7D 00 00 C3           trans $7D,$0000,aRightParen 
1951 21EC 7E 00 00 00           trans $7E,$0000,$0000 
1952 21F1
1953 21F1              *** Keep grave accent unless it's stolen by a foreign language
1954 21F1 60 00 00 B7           trans $60,$0000,aGraveAccent 
1955 21F6
1956 21F6              *** English--keep special characters #, @, [, backsl, ], `, {, |, }, ~
1957 21F6 23 00 20 AD           trans $23,$2000,aPoundSign 
1958 21FB 40 00 20 AF           trans $40,$2000,anAtSign 
1959 2200 5B 00 20 B1           trans $5B,$2000,aLeftBracket 
1960 2205 5C 00 20 B3           trans $5C,$2000,aBackslash 
1961 220A 5D 00 20 B5           trans $5D,$2000,aRightBracket 
1962 220F 7B 00 20 B9           trans $7B,$2000,aLeftBrace 
1963 2214 7C 00 20 BB           trans $7C,$2000,aVertBar 
1964 2219 7D 00 20 BD           trans $7D,$2000,aRightBrace 
1965 221E 7E 00 20 BF           trans $7E,$2000,aTilde 
1966 2223              *** U.K. English
1967 2223 A3 01 20 AD           trans $A3,$2001,aPoundSign     ;£
1968 2228 40 01 20 AF           trans $40,$2001,anAtSign 
1969 222D 5B 01 20 B1           trans $5B,$2001,aLeftBracket 
1970 2232 5C 01 20 B3           trans $5C,$2001,aBackslash 
1971 2237 5D 01 20 B5           trans $5D,$2001,aRightBracket 
1972 223C 7B 01 20 B9           trans $7B,$2001,aLeftBrace 
1973 2241 7C 01 20 BB           trans $7C,$2001,aVertBar 
1974 2246 7D 01 20 BD           trans $7D,$2001,aRightBrace 
1975 224B 7E 01 20 BF           trans $7E,$2001,aTilde 
1976 2250              *** French
1977 2250 A3 02 20 AD           trans $A3,$2002,aPoundSign     ;£
1978 2255 88 02 20 AF           trans $88,$2002,anAtSign       ;grave a
1979 225A A1 02 20 B1           trans $A1,$2002,aLeftBracket   ;degree symbol
1980 225F 8D 02 20 B3           trans $8D,$2002,aBackslash     ;cedilla c
1981 2264 A4 02 20 B5           trans $A4,$2002,aRightBracket  ;paragraph symbol
1982 2269 8E 02 20 B9           trans $8E,$2002,aLeftBrace     ;accent e
1983 226E 9D 02 20 BB           trans $9D,$2002,aVertBar       ;grave u
1984 2273 8F 02 20 BD           trans $8F,$2002,aRightBrace    ;grave e
1985 2278 AC 02 20 BF           trans $AC,$2002,aTilde         ;umlat
1986 227D              *** Danish
1987 227D 23 03 20 AD           trans $23,$2003,aPoundSign 
1988 2282 40 03 20 AF           trans $40,$2003,anAtSign 
1989 2287 AE 03 20 B1           trans $AE,$2003,aLeftBracket   ;AE
1990 228C AF 03 20 B3           trans $AF,$2003,aBackslash     ;big PHI
1991 2291 81 03 20 B5           trans $81,$2003,aRightBracket  ;angstrom A
1992 2296 BE 03 20 B9           trans $BE,$2003,aLeftBrace     ;ae
1993 229B BF 03 20 BB           trans $BF,$2003,aVertBar       ;small PHI
1994 22A0 8C 03 20 BD           trans $8C,$2003,aRightBrace    ;angstrom a
1995 22A5 7E 03 20 BF           trans $7E,$2003,aTilde 
1996 22AA              *** Spanish
1997 22AA A3 04 20 AD           trans $A3,$2004,aPoundSign     ;£
1998 22AF A4 04 20 AF           trans $A4,$2004,anAtSign       ;paragraph
1999 22B4 C1 04 20 B1           trans $C1,$2004,aLeftBracket   ;upside-down bang
2000 22B9 84 04 20 B3           trans $84,$2004,aBackslash     ;tilde N
2001 22BE C0 04 20 B5           trans $C0,$2004,aRightBracket  ;upside-down question
2002 22C3 A1 04 20 B9           trans $A1,$2004,aLeftBrace     ;degree symbol
2003 22C8 96 04 20 BB           trans $96,$2004,aVertBar       ;tilde n
2004 22CD 8D 04 20 BD           trans $8D,$2004,aRightBrace    ;cedilla c
2005 22D2 7E 04 20 BF           trans $7E,$2004,aTilde 
2006 22D7              *** Italian
2007 22D7 A3 05 20 AD           trans $A3,$2005,aPoundSign     ;£
2008 22DC A4 05 20 AF           trans $A4,$2005,anAtSign       ;paragraph
2009 22E1 A1 05 20 B1           trans $A1,$2005,aLeftBracket   ;degree symbol
2010 22E6 8D 05 20 B3           trans $8D,$2005,aBackslash     ;cedilla c
2011 22EB 8E 05 20 B5           trans $8E,$2005,aRightBracket  ;accent e
2012 22F0 9D 05 20 B7           trans $9D,$2005,aGraveAccent   ;grave u
2013 22F5 88 05 20 B9           trans $88,$2005,aLeftBrace     ;grave a
2014 22FA 8F 05 20 BB           trans $8F,$2005,aVertBar       ;grave e
2015 22FF 98 05 20 BD           trans $98,$2005,aRightBrace    ;grave o
2016 2304 93 05 20 BF           trans $93,$2005,aTilde         ;grave i
2017 2309 60 05 20 CE           trans $60,$2005,aSingleQuote   ;grave accent --> quote
2018 230E              *** German
2019 230E 23 06 20 AD           trans $23,$2006,aPoundSign 
2020 2313 A4 06 20 AF           trans $A4,$2006,anAtSign       ;paragraph
2021 2318 80 06 20 B1           trans $80,$2006,aLeftBracket   ;umlat A
2022 231D 85 06 20 B3           trans $85,$2006,aBackslash     ;umlat O
2023 2322 86 06 20 B5           trans $86,$2006,aRightBracket  ;umlat U
2024 2327 8A 06 20 B9           trans $8A,$2006,aLeftBrace     ;umlat a
2025 232C 9A 06 20 BB           trans $9A,$2006,aVertBar       ;umlat o
2026 2331 9F 06 20 BD           trans $9F,$2006,aRightBrace    ;umlat u
2027 2336 A7 06 20 BF           trans $A7,$2006,aTilde         ;"B"
2028 233B              *** Swedish
2029 233B 23 07 20 AD           trans $23,$2007,aPoundSign 
2030 2340 40 07 20 AF           trans $40,$2007,anAtSign 
2031 2345 80 07 20 B1           trans $80,$2007,aLeftBracket   ;umlat A
2032 234A 85 07 20 B3           trans $85,$2007,aBackslash     ;umlat O
2033 234F 81 07 20 B5           trans $81,$2007,aRightBracket  ;angstrom A
2034 2354 8A 07 20 B9           trans $8A,$2007,aLeftBrace     ;umlat a
2035 2359 9A 07 20 BB           trans $9A,$2007,aVertBar       ;umlat o
2036 235E 8C 07 20 BD           trans $8C,$2007,aRightBrace    ;angstrom a
2037 2363 7E 07 20 BF           trans $7E,$2007,aTilde 
2038 2368
2039 2368              *** MouseText translations
2040 2368 11 00 80 28           trans $11,$8000,mtOpenApple    ;hollow Apple
2041 236D 12 00 80 2C           trans $12,$8000,mtCheckMark    ;check mark
2042 2372 13 00 80 30           trans $13,$8000,mtDiamont      ;solid diamond
2043 2377 14 00 80 34           trans $14,$8000,mtSolidApple   ;solid Apple
2044 237C 7F 00 80 38           trans $7F,$8000,mtCheckerboard  ;DEL --> checkerboard
2045 2381 C9 00 80 3C           trans $C9,$8000,mtEllipsis     ;ellipsis
2046 2386 D7 00 80 40           trans $D7,$8000,mtDiamond      ;hollow diamond
2047 238B
2048 238B              *** Generic typographical things
2049 238B A5 00 00 14           trans $A5,$0000,aBullet        ;¥
2050 2390 A8 00 40 16           trans $A8,$4000,aRegistered    ;¨
2051 2395 A9 00 40 1A           trans $A9,$4000,aCopyright     ;©
2052 239A AA 00 40 1E           trans $AA,$4000,aTrademark 
2053 239F AB 00 00 CE           trans $AB,$0000,aSingleQuote   ;forward-slant apostrophe
2054 23A4 AD 00 40 23           trans $AD,$4000,aNotEqual      ;­
2055 23A9 B1 00 40 0B           trans $B1,$4000,aPlusMinus     ;±
2056 23AE B2 00 40 0E           trans $B2,$4000,aLessEqual     ;²
2057 23B3 B3 00 40 11           trans $B3,$4000,aGreatEqual    ;³
2058 23B8 B5 00 00 E2           trans $B5,$0000,aSmallU        ;micro
2059 23BD C4 00 00 DA           trans $C4,$0000,aSmallF        ;Ä
2060 23C2 C7 00 40 05           trans $C7,$4000,aLessLess      ;<<
2061 23C7 C8 00 40 08           trans $C8,$4000,aGreatGreat    ;>>
2062 23CC CA 00 00 C5           trans $CA,$0000,aBlank 
2063 23D1 D0 00 00 C7           trans $D0,$0000,aHyphen        ;Ð
2064 23D6 D1 00 00 C7           trans $D1,$0000,aHyphen        ;if lengthening not allowed
2065 23DB D1 00 40 C9           trans $D1,$4000,aDash          ;Ñ
2066 23E0 D2 00 00 CC           trans $D2,$0000,aDoubleQuote   ;Ò
2067 23E5 D3 00 00 CC           trans $D3,$0000,aDoubleQuote   ;Ó
2068 23EA D4 00 00 CE           trans $D4,$0000,aSingleQuote   ;Ô
2069 23EF D5 00 00 CE           trans $D5,$0000,aSingleQuote   ;Õ
2070 23F4
2071 23F4              *** Things added at Yvan Koenig's request (characters above $D8 are a mystery to me)
2072 23F4 A2 00 00 D6           trans $A2,$0000,aSmallC        ;cent
2073 23F9 B4 00 00 A9           trans $B4,$0000,aBigY          ;Yen
2074 23FE BB 00 00 D4           trans $BB,$0000,aSmallA        ;ordFeminine
2075 2403 BC 00 00 E0           trans $BC,$0000,aSmallO        ;ordMasculine
2076 2408 BD 00 00 F1           trans $BD,$0000,aBigO          ;Omega
2077 240D D9 00 00 A9           trans $D9,$0000,aBigY          ;Y dieresis
2078 2412 DA 00 00 A7           trans $DA,$0000,aSlash         ;Fraction
2079 2417 DB 00 00 E0           trans $DB,$0000,aSmallO        ;currency
2080 241C DC 00 00 A5           trans $DC,$0000,aSmaller       ;guillsingleLeft
2081 2421 DD 00 00 A3           trans $DD,$0000,aGreater       ;guillsingleRight
2082 2426 DE 00 40 A0           trans $DE,$4000,aFI            ;fi
2083 242B DF 00 40 9D           trans $DF,$4000,aFL            ;fl
2084 2430 E1 00 00 9B           trans $E1,$0000,aPeriod        ;periodCentered
2085 2435 E2 00 00 99           trans $E2,$0000,aComma         ;quoteSingleBase
2086 243A E3 00 40 96           trans $E3,$4000,aCommaPair     ;quoteDblBase
2087 243F E5 00 00 E6           trans $E5,$0000,aBigA          ;Acircumflex
2088 2444 E6 00 00 ED           trans $E6,$0000,aBigE          ;Ecircumflex
2089 2449 E7 00 00 E6           trans $E7,$0000,aBigA          ;Aacute
2090 244E E8 00 00 ED           trans $E8,$0000,aBigE          ;Ecircumflex
2091 2453 E9 00 00 ED           trans $E9,$0000,aBigE          ;Egrave
2092 2458 EA 00 00 AB           trans $EA,$0000,aBigI          ;Iacute
2093 245D EB 00 00 AB           trans $EB,$0000,aBigI          ;Icircumflex
2094 2462 EC 00 00 AB           trans $EC,$0000,aBigI          ;Idieresis
2095 2467 ED 00 00 AB           trans $ED,$0000,aBigI          ;Igrave
2096 246C EE 00 00 F1           trans $EE,$0000,aBigO          ;Oacute
2097 2471 EF 00 00 F1           trans $EF,$0000,aBigO          ;Ocircumflex
2098 2476 F0 00 80 34           trans $F0,$8000,mtSolidApple 
2099 247B F1 00 00 F1           trans $F1,$0000,aBigO          ;Ograve
2100 2480 F2 00 00 F3           trans $F2,$0000,aBigU          ;Uacute
2101 2485 F3 00 00 F3           trans $F3,$0000,aBigU          ;Ucircumflex
2102 248A F4 00 00 F3           trans $F4,$0000,aBigU          ;Ugrave
2103 248F F5 00 00 DC           trans $F5,$0000,aSmallI        ;dotless i
2104 2494              XlateEnd  
2105 2494
2106 2494              *** new entries 16-Jan-92 DAL
2107 2494 01 49        aUpperI  DC B:1,'I'
2108 2496 02 2C 2C     aCommaPair DC B:2,',,'
2109 2499 01 2C        aComma   DC B:1,','
2110 249B 01 2E        aPeriod  DC B:1,'.'
2111 249D 02 66 6C     aFL      DC B:2,'fl'
2112 24A0 02 66 69     aFI      DC B:2,'fi'
2113 24A3 01 3E        aGreater DC B:1,'>'
2114 24A5 01 3C        aSmaller DC B:1,'<'
2115 24A7 01 2F        aSlash   DC B:1,'/'
2116 24A9 01 59        aBigY    DC B:1,'Y'
2117 24AB 01 49        aBigI    DC B:1,'I'
2118 24AD              *** end 16-Jan-92
2119 24AD
2120 24AD 01 23        aPoundSign DC B:1,'#'
2121 24AF 01 40        anAtSign DC B:1,'@'
2122 24B1 01 5B        aLeftBracket DC B:1,'['
2123 24B3 01 5C        aBackslash DC B:1,'\'
2124 24B5 01 5D        aRightBracket DC B:1,']'
2125 24B7 01 60        aGraveAccent DC B:1,'`'
2126 24B9 01 7B        aLeftBrace DC B:1,'{'
2127 24BB 01 7C        aVertBar DC B:1,'|'
2128 24BD 01 7D        aRightBrace DC B:1,'}'
2129 24BF 01 7E        aTilde   DC B:1,'~'
2130 24C1
2131 24C1 01 28        aLeftParen DC B:1,'('
2132 24C3 01 29        aRightParen DC B:1,')'
2133 24C5
2134 24C5 01 20        aBlank   DC B:1,' '
2135 24C7 01 2D        aHyphen  DC B:1,'-'
2136 24C9 02 2D 2D     aDash    DC B:2,'--'
2137 24CC 01 22        aDoubleQuote DC B:1,$22
2138 24CE 01 27        aSingleQuote DC B:1,$27
2139 24D0 01 3F        aQuestion DC B:1,'?'
2140 24D2 01 21        aBang    DC B:1,'!'
2141 24D4 01 61        aSmallA  DC B:1,'a'
2142 24D6 01 63        aSmallC  DC B:1,'c'
2143 24D8 01 65        aSmallE  DC B:1,'e'
2144 24DA 01 66        aSmallF  DC B:1,'f'
2145 24DC 01 69        aSmalli  DC B:1,'i'
2146 24DE 01 6E        aSmallN  DC B:1,'n'
2147 24E0 01 6F        aSmallO  DC B:1,'o'
2148 24E2 01 75        aSmallU  DC B:1,'u'
2149 24E4 01 79        aSmallY  DC B:1,'y'
2150 24E6 01 41        aBigA    DC B:1,'A'
2151 24E8              ;;;aBigB	dc.b	1,'B'
2152 24E8 02 73 73     aSmallSS DC B:2,'ss'                    ;16-Jan-92 DAL
2153 24EB 01 43        aBigC    DC B:1,'C'
2154 24ED 01 45        aBigE    DC B:1,'E'
2155 24EF 01 4E        aBigN    DC B:1,'N'
2156 24F1 01 4F        aBigO    DC B:1,'O'
2157 24F3 01 55        aBigU    DC B:1,'U'
2158 24F5 02 61 65     aSmallAE DC B:2,'ae'
2159 24F8 02 41 45     aBigAE   DC B:2,'AE'
2160 24FB 02 6F 65     aSmallOE DC B:2,'oe'
2161 24FE 02 4F 45     aBigOE   DC B:2,'OE'
2162 2501 03 2E 2E 2E  anEllipsis DC B:3,'...'
2163 2505 02 3C 3C     aLessLess DC B:2,'<<'
2164 2508 02 3E 3E     aGreatGreat DC B:2,'>>'
2165 250B 02 2B 2D     aPlusMinus DC B:2,'+-'
2166 250E 02 3C 3D     aLessEqual DC B:2,'<='
2167 2511 02 3E 3D     aGreatEqual DC B:2,'>='
2168 2514 01 2A        aBullet  DC B:1,'*'
2169 2516 03 28 52 29  aRegistered DC B:3,'(R)'
2170 251A 03 28 43 29  aCopyright DC B:3,'(C)'
2171 251E 04 28 54 4D  aTrademark DC B:4,'(TM)'
2172 2523 02 3C 3E     aNotEqual DC B:2,'<>'
2173 2526 01 30        aZero    DC B:1,'0'
2174 2528
2175 2528 03 0F 41 0E  mtOpenApple DC B:3,15,$41,14            ;hollow Apple
2176 252C 03 0F 44 0E  mtCheckMark DC B:3,15,$44,14            ;check mark (normal)
2177 2530 03 0F 5B 0E  mtDiamont DC B:3,15,$5B,14              ;solid diamond
2178 2534 03 0F 40 0E  mtSolidApple DC B:3,15,$40,14           ;solid Apple
2179 2538 03 0F 56 0E  mtCheckerboard DC B:3,15,$56,14         ;DEL --> checkerboard
2180 253C 03 0F 49 0E  mtEllipsis DC B:3,15,$49,14             ;ellipsis
2181 2540 03 0F 5B 0E  mtDiamond DC B:3,15,$5B,14              ;hollow diamond
2182 2544
2183 2544 00 00        passThruFlag DC W:0                     ;16-Jan-92 DAL
2184 2546
2185 2546                       EndP 
2186 2546
2187 2546
2188 2546              **********************************************************************
2189 2546              *
2190 2546              * ScanDevices -- new call 29-Mar-91 DAL
2191 2546              *
2192 2546              * Inputs:
2193 2546              *   WORD  space for result
2194 2546              *
2195 2546              * Outputs:
2196 2546              *   WORD  device number of insertion (zero if none)
2197 2546              *
2198 2546              **********************************************************************
2199 2546              ScanDevices proc export 
2200 2546
2201 2546              DO_INSERT_SCAN equ   $01FCDC
2202 2546
2203 2546 E2 20                 sep   #$20
2204 2548                       longa off
2205 2548 AF 68 C0 E0           lda   >$e0c068
2206 254C 48                    pha   
2207 254D AF 8B C0 E0           lda   >$e0c08b
2208 2551 AF 8B C0 E0           lda   >$e0c08b
2209 2555
2210 2555              *** Removed 20-Aug-92 DAL -- not needed
2211 2555              ;;;	ldx	#0	;anticipate OS vector missing
2212 2555              ;;;	lda	>DO_INSERT_SCAN
2213 2555              ;;;	cmp	#$5c
2214 2555              ;;;	bne	@notThere
2215 2555
2216 2555 C2 20                 rep   #$20
2217 2557                       longa on
2218 2557 22 DC FC 01           jsl   DO_INSERT_SCAN           ;do_insert_scan
2219 255B AA                    tax   
2220 255C E2 20        @notThere sep   #$20
2221 255E 68                    pla   
2222 255F 8F 68 C0 E0           sta   >$e0c068
2223 2563 C2 20                 rep   #$20
2224 2565 8A                    txa   
2225 2566 83 07                 sta   7,s
2226 2568 A9 00 00              lda   #0
2227 256B 18                    clc   
2228 256C 6B                    rtl   
2229 256D
2230 256D                       EndP 
2231 256D
2232 256D              **********************************************************************
2233 256D              *
2234 256D              * AlertMessage -- new call 20-Aug-92 DAL for 6.0.1
2235 256D              *
2236 256D              * Inputs:
2237 256D              *   WORD  space for result
2238 256D              *   LONG  pointer to message table (see below)
2239 256D              *   WORD  message number (0=first)
2240 256D              *   LONG  pointer to substitution table (Pascal strings)
2241 256D              *
2242 256D              * Behavior:
2243 256D              *   If GS/OS is not present, return error $0377.
2244 256D              *   Call s_toolbox_msg vector in GS/OS.
2245 256D              *
2246 256D              * The message table goes like this:
2247 256D              *    dc.w messageZeroText-*,messageZeroGraphics-*
2248 256D              *    dc.w messageOneText-*,messageOneGraphics-*
2249 256D              *    ...
2250 256D              *
2251 256D              * Each message is an AlertWindow string plus three characters to
2252 256D              * map the buttons into return values.  (The characters should be
2253 256D              * '0' to '9', indicating what values to return when the first,
2254 256D              * second, and third buttons are chosen.)
2255 256D              *
2256 256D              * Both string offsets can point to the same string if you want, but
2257 256D              * the text version does not do word wrapping for you.
2258 256D              *
2259 256D              * The text version does *0..*9 and "^" for default button, but
2260 256D              * it does not do the "#" CompileText substitutions like AlertWindow.
2261 256D              *
2262 256D              **********************************************************************
2263 256D              AlertMessage proc export 
2264 256D
2265 256D              IncBusy  equ   $e10064
2266 256D              sys_prefs equ   $00b9f6                 ;GS/OS system preferences
2267 256D              s_toolbox_msg equ   $01fce0
2268 256D
2269 256D 0B                    phd   
2270 256E 3B                    tsc   
2271 256F 5B                    tcd   
2272 2570
2273 2570              @oldD    equ   1
2274 2570              @rtl     equ   @oldD+2
2275 2570              @substitutions equ   @rtl+6
2276 2570              @msg_number equ   @substitutions+4
2277 2570              @table   equ   @msg_number+2
2278 2570              @result  equ   @table+4
2279 2570
2280 2570 22 64 00 E1           jsl   IncBusy
2281 2574
2282 2574 AF F6 B9 00           lda   >sys_prefs
2283 2578 48                    pha   
2284 2579 29 FF DF              and   #$dfff                   ;don't supress messages!
2285 257C 8F F6 B9 00           sta   >sys_prefs
2286 2580
2287 2580 A9 FF FF              lda   #$ffff
2288 2583 85 13                 sta   <@result
2289 2585
2290 2585 A2 77 03              ldx   #$0377                   ;anticipate no-GS/OS error
2291 2588 AF BC 00 E1           lda   >OS_Kind                 ;$00=P8, $01 = GS/OS)
2292 258C 29 FF 00              and   #$00ff
2293 258F F0 2D                 beq   @error
2294 2591
2295 2591 E2 20                 sep   #$20
2296 2593                       longa off
2297 2593 AF 68 C0 E0           lda   >$e0c068
2298 2597 48                    pha   
2299 2598 AF 8B C0 E0           lda   >$e0c08b
2300 259C AF 8B C0 E0           lda   >$e0c08b
2301 25A0 C2 20                 rep   #$20
2302 25A2                       longa on
2303 25A2
2304 25A2 D4 0D                 pei   <@msg_number
2305 25A4 D4 0B                 pei   <@substitutions+2
2306 25A6 D4 09                 pei   <@substitutions
2307 25A8 A6 0F                 ldx   <@table                  ;set up YX = pointer to error msg table
2308 25AA A4 11                 ldy   <@table+2
2309 25AC 22 E0 FC 01           jsl   s_toolbox_msg
2310 25B0 85 13                 sta   <@result
2311 25B2
2312 25B2 E2 20                 sep   #$20
2313 25B4 68                    pla   
2314 25B5 8F 68 C0 E0           sta   >$e0c068
2315 25B9 C2 20                 rep   #$20
2316 25BB
2317 25BB A2 00 00     @exit    ldx   #0                       ;error code
2318 25BE 68           @error   pla   
2319 25BF 8F F6 B9 00           sta   >sys_prefs
2320 25C3 2B                    pld   
2321 25C4 A0 0A 00              ldy   #10                      ;bytes to strip
2322 25C7 5C 80 01 E1           jml   $e10180                  ;ToBusyStrip
2323 25CB
2324 25CB                       EndP 
2325 25CB
2326 25CB
2327 25CB              **********************************************************************
2328 25CB              *
2329 25CB              * DoSysPrefs -- new call 20-Aug-92 DAL for 6.0.1
2330 25CB              *
2331 25CB              * Inputs:
2332 25CB              *    WORD  space for result
2333 25CB              *    WORD  bits to clear
2334 25CB              *    WORD  bits to set
2335 25CB              *
2336 25CB              * Behavior:
2337 25CB              *   Clears the specified GS/OS SysPrefs bits.
2338 25CB              *   Sets the specified GS/OS SysPrefs bits.
2339 25CB              *   Returns the new SysPrefs word.
2340 25CB              *
2341 25CB              **********************************************************************
2342 25CB              DoSysPrefs proc export 
2343 25CB
2344 25CB              sys_prefs equ   $00b9f6                 ;GS/OS system preferences
2345 25CB
2346 25CB              @rtl     equ   1
2347 25CB              @bitsToSet equ   @rtl+6
2348 25CB              @bitsToClear equ   @bitsToSet+2
2349 25CB              @result  equ   @bitsToClear+2
2350 25CB
2351 25CB              *** added 22-Oct-92 DAL -- return error $0301 under ProDOS 8
2352 25CB A2 01 03              ldx   #$0301                   ;anticipate error
2353 25CE AF BC 00 E1           lda   >$e100bc
2354 25D2 29 FF 00              and   #$00ff
2355 25D5 F0 18                 beq   @error
2356 25D7              *** end 22-Oct-92
2357 25D7
2358 25D7 AF F6 B9 00           lda   >sys_prefs
2359 25DB 83 0B                 sta   @result,s                ;1-Oct-92 DAL
2360 25DD
2361 25DD A3 09                 lda   @bitsToClear,s
2362 25DF 49 FF FF              eor   #$ffff
2363 25E2 2F F6 B9 00           and   >sys_prefs
2364 25E6 03 07                 ora   @bitsToSet,s
2365 25E8 8F F6 B9 00           sta   >sys_prefs
2366 25EC
2367 25EC A2 00 00              ldx   #0
2368 25EF A0 04 00     @error   ldy   #4
2369 25F2 5C 84 01 E1           jml   $e10184                  ;ToStrip
2370 25F6
2371 25F6                       EndP 
2372 25F6
2373 25F6              **********************************************************************
2374 25F6              *
2375 25F6              * ShowBootInfo -- new call 29-Mar-91 DAL for 6.0
2376 25F6              *
2377 25F6              * Inputs:
2378 25F6              *    LONG  Pascal string pointer or NIL
2379 25F6              *            (Set bit 31 of string pointer to reinitialize ShowBootInfo)
2380 25F6              *    LONG  Icon pointer (DrawIcon style) or NIL
2381 25F6              *            (Set bit 31 of icon pointer to re-use previous location)
2382 25F6              *
2383 25F6              *
2384 25F6              * The text-based splash screen has lines in this format:
2385 25F6              *    "System Dispatch Table v04.00d4"
2386 25F6              *    "ProDOS FST            v04.00"
2387 25F6              *    (22 characters before the version)
2388 25F6              *
2389 25F6              * The input string should be in this format.
2390 25F6              *
2391 25F6              * Icon format:
2392 25F6              *   +000: iconType
2393 25F6              *   +002: icon size
2394 25F6              *   +004: icon height
2395 25F6              *   +006: icon width (in 4-bit pixels)
2396 25F6              *
2397 25F6              **********************************************************************
2398 25F6              ShowBootInfo proc export 
2399 25F6
2400 25F6              ;;;PlasterIconsHere	equ	174*160+$E12000
2401 25F6              BottomRow equ   174*160+$2000
2402 25F6              RowDecrement equ   26*160
2403 25F6              TheScreen equ   $e12000
2404 25F6
2405 25F6              FirstIconPosition equ   2               ;horizontal byte offset
2406 25F6
2407 25F6 0B                    phd   
2408 25F7 48                    pha   
2409 25F8 48                    pha                            ;space for @screen
2410 25F9 48                    pha   
2411 25FA 48                    pha                            ;space for @mask
2412 25FB 48                    pha   
2413 25FC 48                    pha                            ;space for @ptr
2414 25FD 3B                    tsc   
2415 25FE 5B                    tcd   
2416 25FF
2417 25FF              @ptr     equ   1
2418 25FF              @mask    equ   @ptr+4
2419 25FF              @screen  equ   @mask+4
2420 25FF              @oldD    equ   @screen+4
2421 25FF              @rtl     equ   @oldD+2
2422 25FF              @icon    equ   @rtl+6
2423 25FF              @string  equ   @icon+4
2424 25FF
2425 25FF              *** bit 31 of stringPtr = initialize self!
2426 25FF A5 1B                 lda   <@string+2
2427 2601 10 15                 bpl   @notInit
2428 2603 A9 FF FF              lda   #$ffff
2429 2606 8F 66 2C 02           sta   >FirstTextLine
2430 260A A9 02 00              lda   #FirstIconPosition
2431 260D 8F 62 2C 02           sta   >IconXPosition
2432 2611 A9 C0 8C              lda   #BottomRow
2433 2614 8F 68 2C 02           sta   >PlasterIconsHere
2434 2618              @notInit  
2435 2618
2436 2618              *** If QuickDraw is active, don't do anything (in something gets initted at
2437 2618              *** other than boot time!)
2438 2618 F4 00 00              pea   0
2439 261B A2 04 06 22           _QDStatus 
2440 2622 68                    pla   
2441 2623 D0 45                 bne   @exit
2442 2625
2443 2625 AF 29 C0 E0           lda   >$e0c029
2444 2629 29 80 00              and   #$0080
2445 262C D0 34                 bne   @doTheIcon
2446 262E
2447 262E A5 1A        @doTheString lda   <@string+1
2448 2630 F0 2E                 beq   @noString
2449 2632
2450 2632 AF 66 2C 02           lda   >FirstTextLine
2451 2636 10 0D                 bpl   @notFirstTime
2452 2638 A9 00 00              lda   #0
2453 263B 8F 66 2C 02           sta   >FirstTextLine
2454 263F A2 8E FD              ldx   #$fd8e                   ;CROUT
2455 2642 20 82 2C              jsr   call_fw
2456 2645              @notFirstTime  
2457 2645
2458 2645 A0 00 00              ldy   #0                       ;start at first byte to display
2459 2648 B7 19        @charloop lda   [<@string],y            ;pick up a character to display
2460 264A 29 FF 00              and   #$00ff
2461 264D F0 0B                 beq   @done                    ;$00 is terminator
2462 264F 09 80 00              ora   #$0080                   ;set high bit in case someone forgot!!!
2463 2652 5A                    phy                            ;save Y
2464 2653 20 7F 2C              jsr   call_cout                ;output the character
2465 2656 7A                    ply                            ;restore Y
2466 2657 C8                    iny                            ;next character please
2467 2658 80 EE                 bra   @charloop                ;fall out
2468 265A              @done     
2469 265A A2 8E FD              ldx   #$fd8e                   ;CROUT
2470 265D 20 82 2C              jsr   call_fw
2471 2660 80 08        @noString bra   @exit
2472 2662
2473 2662
2474 2662 A5 16        @doTheIcon lda   <@icon+1
2475 2664 F0 04                 beq   @noIcon
2476 2666 22 7B 2B 02           jsl   @DrawTheIcon
2477 266A              @noIcon   
2478 266A
2479 266A 68           @exit    pla   
2480 266B 68                    pla                            ;pulled @ptr
2481 266C 68                    pla   
2482 266D 68                    pla                            ;pulled @mask
2483 266E 68                    pla   
2484 266F 68                    pla                            ;pulled @screen
2485 2670 2B                    pld   
2486 2671 A2 00 00              ldx   #0
2487 2674 A0 08 00              ldy   #8
2488 2677 5C 84 01 E1           jml   $e10184                  ;ToStrip
2489 267B
2490 267B              @DrawTheIcon  
2491 267B
2492 267B              *** If bit 1 of BRAM $5F is set, skip drawing the icon
2493 267B 48           @verifyBRAM pha   
2494 267C F4 5F 00              pea   $5f
2495 267F A2 03 0C 22           _ReadBParam 
2496 2686 68                    pla   
2497 2687 AA                    tax   
2498 2688 29 C0 00              and   #%11000000
2499 268B C9 80 00              cmp   #%10000000
2500 268E F0 0F                 beq   @okay
2501 2690 F4 81 00              pea   $81                      ;Initialize toolbox location to default value ($81)
2502 2693 F4 5F 00              pea   $5F
2503 2696 A2 03 0B 22           _WriteBParam 
2504 269D 80 07                 bra   @continueIcon
2505 269F
2506 269F 8A           @okay    txa   
2507 26A0 29 02 00              and   #$0002                   ;bit 1 = disable icon drawing
2508 26A3 F0 01                 beq   @continueIcon
2509 26A5 6B                    rtl   
2510 26A6              @continueIcon  
2511 26A6
2512 26A6              *** If bit 31 is set, re-use the previous icon position
2513 26A6 A5 17                 lda   <@icon+2
2514 26A8 10 08                 bpl   @nextPosition
2515 26AA AF 64 2C 02           lda   >oldIconXPosition
2516 26AE 8F 62 2C 02           sta   >IconXPosition
2517 26B2              @nextPosition  
2518 26B2 18                    clc   
2519 26B3 A5 15                 lda   <@icon
2520 26B5 69 08 00              adc   #8
2521 26B8 85 01                 sta   <@ptr
2522 26BA A5 17                 lda   <@icon+2
2523 26BC 69 00 00              adc   #0
2524 26BF 85 03                 sta   <@ptr+2
2525 26C1
2526 26C1 A0 02 00              ldy   #2                       ;offset to icon size
2527 26C4 A5 01                 lda   <@ptr
2528 26C6 77 15                 adc   [<@icon],y
2529 26C8 85 05                 sta   <@mask
2530 26CA A5 03                 lda   @ptr+2
2531 26CC 69 00 00              adc   #0
2532 26CF 85 07                 sta   <@mask+2
2533 26D1
2534 26D1 A0 06 00              ldy   #6
2535 26D4 B7 15                 lda   [<@icon],y               ;got the width (must be even)
2536 26D6 4A                    lsr   a                        ;width in bytes
2537 26D7 6F 62 2C 02           adc   >IconXPosition
2538 26DB C9 A0 00              cmp   #160
2539 26DE 90 0A                 bcc   @ok
2540 26E0 20 6A 2C              jsr   BeginNewRow
2541 26E3 A9 02 00              lda   #FirstIconPosition
2542 26E6 8F 62 2C 02           sta   >IconXPosition
2543 26EA              @ok       
2544 26EA
2545 26EA A9 E1 00              lda   #^TheScreen              ;12-Mar-92 DAL
2546 26ED 85 0B                 sta   <@screen+2
2547 26EF AF 68 2C 02           lda   >PlasterIconsHere        ;12-Mar-92 DAL
2548 26F3 18                    clc   
2549 26F4 6F 62 2C 02           adc   >IconXPosition
2550 26F8 85 09                 sta   <@screen
2551 26FA
2552 26FA A0 04 00              ldy   #4
2553 26FD B7 15                 lda   [<@icon],y               ;got height
2554 26FF 48           @doOneLine pha   
2555 2700
2556 2700 A0 06 00              ldy   #6
2557 2703 B7 15                 lda   [<@icon],y
2558 2705 4A                    lsr   a
2559 2706 AA                    tax                            ;byte count
2560 2707 A0 00 00              ldy   #0
2561 270A E2 30                 sep   #$30
2562 270C B7 01        @doOneByte lda   [<@ptr],y
2563 270E 57 09                 eor   [<@screen],y
2564 2710 37 05                 and   [@mask],y
2565 2712 57 09                 eor   [<@screen],y
2566 2714 97 09                 sta   [<@screen],y
2567 2716 C8                    iny   
2568 2717 CA                    dex   
2569 2718 D0 F2                 bne   @doOneByte
2570 271A C2 30                 rep   #$30
2571 271C
2572 271C              *** advance to next row
2573 271C A0 06 00              ldy   #6
2574 271F B7 15                 lda   [<@icon],y               ;width (pixels)
2575 2721 4A                    lsr   a
2576 2722 AA                    tax   
2577 2723 65 01                 adc   <@ptr
2578 2725 85 01                 sta   <@ptr
2579 2727 90 02                 bcc   @1
2580 2729 E6 03                 inc   <@ptr+2
2581 272B 8A           @1       txa   
2582 272C 18                    clc   
2583 272D 65 05                 adc   <@mask
2584 272F 85 05                 sta   <@mask
2585 2731 90 02                 bcc   @2
2586 2733 E6 07                 inc   <@mask+2
2587 2735 18           @2       clc   
2588 2736 A5 09                 lda   <@screen
2589 2738 69 A0 00              adc   #160
2590 273B 85 09                 sta   <@screen
2591 273D AA                    tax                            ;6-May-91 DAL
2592 273E 68                    pla                            ;row counter
2593 273F              *** See if we hit the bottom of the screen yet
2594 273F E0 00 9D              cpx   #$9d00
2595 2742 B0 03                 bcs   @hitBottom
2596 2744 3A                    dec   a
2597 2745 D0 B8                 bne   @doOneLine
2598 2747
2599 2747              @hitBottom  
2600 2747              *** Keep previous icon position for later
2601 2747 AF 62 2C 02           lda   >IconXPosition
2602 274B 8F 64 2C 02           sta   >oldIconXPosition
2603 274F
2604 274F 18                    clc   
2605 2750 A0 06 00              ldy   #6
2606 2753 B7 15                 lda   [<@icon],y               ;width (pixels)
2607 2755 4A                    lsr   a
2608 2756 6F 62 2C 02           adc   >IconXPosition
2609 275A 69 02 00              adc   #2
2610 275D 8F 62 2C 02           sta   >IconXPosition
2611 2761
2612 2761 6B                    rtl   
2613 2762
2614 2762 02 00        IconXPosition DC W:FirstIconPosition
2615 2764 02 00        oldIconXPosition DC W:FirstIconPosition ;added 20-May-91 DAL
2616 2766 FF FF        FirstTextLine DC W:$ffff
2617 2768
2618 2768 C0 8C        PlasterIconsHere DC W:BottomRow
2619 276A
2620 276A              ;
2621 276A              ; BeginNewRow
2622 276A              ;
2623 276A AF 68 2C 02  BeginNewRow lda   >PlasterIconsHere
2624 276E 38                    sec   
2625 276F E9 40 10              sbc   #RowDecrement
2626 2772 C9 A0 20              cmp   #$20a0                   ;off the top?
2627 2775 B0 03                 bcs   @okay
2628 2777 A9 C0 8C              lda   #BottomRow
2629 277A 8F 68 2C 02  @okay    sta   >PlasterIconsHere
2630 277E 60                    rts   
2631 277F
2632 277F A2 ED FD     call_cout ldx   #$fded
2633 2782 48           call_fw  pha                            ;push space for result
2634 2783 48                    pha   
2635 2784 48                    pha   
2636 2785 48                    pha   
2637 2786 48                    pha                            ;push A
2638 2787 DA                    phx                            ;push X
2639 2788 5A                    phy                            ;push Y
2640 2789 DA                    phx                            ;address of routine to call
2641 278A A2 03 24 22           _FWEntry 
2642 2791 68                    pla                            ;ignore results
2643 2792 68                    pla   
2644 2793 68                    pla   
2645 2794 68                    pla   
2646 2795 60                    rts   
2647 2796
2648 2796                       EndP 
2649 2796
2650 2796                       END   
